/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xmpp.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jivesoftware.smack.packet.Message;
import org.springframework.integration.mapping.AbstractHeaderMapper;
import org.springframework.integration.xmpp.support.XmppHeaderMapper;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultXmppHeaderMapper
extends AbstractHeaderMapper<Message>
implements XmppHeaderMapper {
    private static final List<String> STANDARD_HEADER_NAMES = new ArrayList<String>();

    protected Map<String, Object> extractStandardHeaders(Message source) {
        Message.Type type;
        String to;
        String thread;
        String subject;
        HashMap<String, Object> headers = new HashMap<String, Object>();
        String from = source.getFrom();
        if (StringUtils.hasText((String)from)) {
            headers.put("xmpp_from", from);
        }
        if (StringUtils.hasText((String)(subject = source.getSubject()))) {
            headers.put("xmpp_subject", subject);
        }
        if (StringUtils.hasText((String)(thread = source.getThread()))) {
            headers.put("xmpp_thread", thread);
        }
        if (StringUtils.hasText((String)(to = source.getTo()))) {
            headers.put("xmpp_to", to);
        }
        if ((type = source.getType()) != null) {
            headers.put("xmpp_type", type);
        }
        return headers;
    }

    protected Map<String, Object> extractUserDefinedHeaders(Message source) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        for (String propertyName : source.getPropertyNames()) {
            headers.put(propertyName, source.getProperty(propertyName));
        }
        return headers;
    }

    protected void populateStandardHeaders(Map<String, Object> headers, Message target) {
        Object typeHeader;
        block8: {
            String subject;
            String from;
            String to;
            String threadId = (String)this.getHeaderIfAvailable(headers, "xmpp_thread", String.class);
            if (StringUtils.hasText((String)threadId)) {
                target.setThread(threadId);
            }
            if (StringUtils.hasText((String)(to = (String)this.getHeaderIfAvailable(headers, "xmpp_to", String.class)))) {
                target.setTo(to);
            }
            if (StringUtils.hasText((String)(from = (String)this.getHeaderIfAvailable(headers, "xmpp_from", String.class)))) {
                target.setFrom(from);
            }
            if (StringUtils.hasText((String)(subject = (String)this.getHeaderIfAvailable(headers, "xmpp_subject", String.class)))) {
                target.setSubject(subject);
            }
            if ((typeHeader = this.getHeaderIfAvailable(headers, "xmpp_type", Object.class)) instanceof String) {
                try {
                    typeHeader = Message.Type.valueOf((String)((String)typeHeader));
                }
                catch (Exception e) {
                    if (!this.logger.isWarnEnabled()) break block8;
                    this.logger.warn((Object)"XMPP Type must be either a valid [Message.Type] enum value or a String representation of such.");
                }
            }
        }
        if (typeHeader instanceof Message.Type) {
            target.setType((Message.Type)typeHeader);
        }
    }

    protected void populateUserDefinedHeader(String headerName, Object headerValue, Message target) {
        target.setProperty(headerName, headerValue);
    }

    protected List<String> getStandardReplyHeaderNames() {
        return STANDARD_HEADER_NAMES;
    }

    protected List<String> getStandardRequestHeaderNames() {
        return STANDARD_HEADER_NAMES;
    }

    protected String getStandardHeaderPrefix() {
        return "xmpp_";
    }

    static {
        STANDARD_HEADER_NAMES.add("xmpp_from");
        STANDARD_HEADER_NAMES.add("xmpp_subject");
        STANDARD_HEADER_NAMES.add("xmpp_thread");
        STANDARD_HEADER_NAMES.add("xmpp_to");
        STANDARD_HEADER_NAMES.add("xmpp_type");
    }
}

