/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xmpp.core;

import org.jivesoftware.smack.XMPPConnection;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.util.Assert;

public abstract class AbstractXmppConnectionAwareMessageHandler
extends AbstractMessageHandler {
    protected volatile XMPPConnection xmppConnection;
    protected volatile boolean initialized;

    public AbstractXmppConnectionAwareMessageHandler() {
    }

    public AbstractXmppConnectionAwareMessageHandler(XMPPConnection xmppConnection) {
        Assert.notNull((Object)xmppConnection, (String)"XMPPConnection must not be null");
        this.xmppConnection = xmppConnection;
    }

    protected void onInit() throws Exception {
        BeanFactory beanFactory = this.getBeanFactory();
        if (this.xmppConnection == null && beanFactory != null) {
            this.xmppConnection = (XMPPConnection)beanFactory.getBean("xmppConnection", XMPPConnection.class);
        }
        Assert.notNull((Object)this.xmppConnection, (String)"Failed to resolve XMPPConnection. XMPPConnection must either be set explicitly via 'xmpp-connection' attribute or implicitly by registering a bean with the name 'xmppConnection' and of type 'org.jivesoftware.smack.XMPPConnection' in the Application Context.");
        this.initialized = true;
    }
}

