/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.core;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.config.java.annotation.ExternalBean;
import org.springframework.config.java.core.AbstractBeanMethodProcessor;
import org.springframework.config.java.naming.BeanNamingStrategy;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalBeanMethodProcessor
extends AbstractBeanMethodProcessor {
    private final BeanFactory owningBeanFactory;
    private final BeanNamingStrategy namingStrategy;

    public ExternalBeanMethodProcessor(BeanFactory owningBeanFactory, BeanNamingStrategy namingStrategy) {
        super(ExternalBean.class);
        Assert.notNull((Object)owningBeanFactory, (String)"owningBeanFactory is required");
        Assert.notNull((Object)namingStrategy, (String)"namingStrategy is required");
        this.owningBeanFactory = owningBeanFactory;
        this.namingStrategy = namingStrategy;
    }

    private ExternalBeanMethodProcessor() {
        super(ExternalBean.class);
        this.owningBeanFactory = null;
        this.namingStrategy = null;
    }

    @Override
    public Object processMethod(Method targetMethod) {
        ExternalBean externalBean = (ExternalBean)AnnotationUtils.findAnnotation((Method)targetMethod, ExternalBean.class);
        Assert.notNull((Object)externalBean, (String)"method must be annotated with @ExternalBean");
        Assert.isTrue((!Modifier.isPrivate(targetMethod.getModifiers()) ? 1 : 0) != 0, (String)"@ExternalBean methods may not be private");
        String beanName = !"".equals(externalBean.value()) ? externalBean.value() : this.namingStrategy.getBeanName(targetMethod);
        return this.owningBeanFactory.getBean(beanName);
    }

    public static Collection<Method> findExternalBeanCreationMethods(Class<?> configurationClass) {
        return new ExternalBeanMethodProcessor().findMatchingMethods(configurationClass);
    }

    public static boolean isExternalBeanCreationMethod(Method candidateMethod) {
        return new ExternalBeanMethodProcessor().understands(candidateMethod);
    }
}

