/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.enhancement.cglib;

import java.lang.reflect.Method;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.springframework.config.java.core.ScopedProxyMethodProcessor;
import org.springframework.config.java.enhancement.cglib.BeanMethodMethodInterceptor;
import org.springframework.util.Assert;

class ScopedProxyBeanMethodMethodInterceptor
implements MethodInterceptor {
    private final BeanMethodMethodInterceptor delegate;
    private final ScopedProxyMethodProcessor scopedProxyMethodProcessor;

    public ScopedProxyBeanMethodMethodInterceptor(ScopedProxyMethodProcessor spmp, BeanMethodMethodInterceptor delegate) {
        Assert.notNull((Object)spmp, (String)"the BeanMethodProcessor is required");
        Assert.notNull((Object)delegate, (String)"the MethodInterceptor delegate is required");
        this.scopedProxyMethodProcessor = spmp;
        this.delegate = delegate;
    }

    public Object intercept(Object o, Method m, Object[] args, MethodProxy mp) throws Throwable {
        String beanToReturn = this.scopedProxyMethodProcessor.processMethod(m);
        return this.delegate.returnWrappedResultMayBeCached(beanToReturn, o, m, args, mp);
    }
}

