/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.config;

import java.util.concurrent.Executor;
import org.springframework.kafka.config.KafkaListenerContainerFactory;
import org.springframework.kafka.config.KafkaListenerEndpoint;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.listener.AbstractMessageListenerContainer;
import org.springframework.kafka.listener.ErrorHandler;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.kafka.support.converter.MessageConverter;

public abstract class AbstractKafkaListenerContainerFactory<C extends AbstractMessageListenerContainer<K, V>, K, V>
implements KafkaListenerContainerFactory<C> {
    private ConsumerFactory<K, V> consumerFactory;
    private ErrorHandler errorHandler;
    private Boolean autoStartup;
    private Integer phase;
    private Executor taskExecutor;
    private Integer ackCount;
    private AbstractMessageListenerContainer.AckMode ackMode;
    private Long pollTimeout;
    private MessageConverter messageConverter;

    public void setConsumerFactory(ConsumerFactory<K, V> consumerFactory) {
        this.consumerFactory = consumerFactory;
    }

    public ConsumerFactory<K, V> getConsumerFactory() {
        return this.consumerFactory;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setTaskExecutor(Executor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setAutoStartup(Boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public void setAckCount(Integer ackCount) {
        this.ackCount = ackCount;
    }

    public void setAckMode(AbstractMessageListenerContainer.AckMode ackMode) {
        this.ackMode = ackMode;
    }

    public void setPollTimeout(Long pollTimeout) {
        this.pollTimeout = pollTimeout;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    @Override
    public C createListenerContainer(KafkaListenerEndpoint endpoint) {
        C instance = this.createContainerInstance(endpoint);
        if (this.taskExecutor != null) {
            ((AbstractMessageListenerContainer)instance).setTaskExecutor(this.taskExecutor);
        }
        if (this.errorHandler != null) {
            ((AbstractMessageListenerContainer)instance).setErrorHandler(this.errorHandler);
        }
        if (this.autoStartup != null) {
            ((AbstractMessageListenerContainer)instance).setAutoStartup(this.autoStartup);
        }
        if (this.phase != null) {
            ((AbstractMessageListenerContainer)instance).setPhase(this.phase);
        }
        if (this.ackCount != null) {
            ((AbstractMessageListenerContainer)instance).setAckCount(this.ackCount);
        }
        if (this.ackMode != null) {
            ((AbstractMessageListenerContainer)instance).setAckMode(this.ackMode);
        }
        if (endpoint.getId() != null) {
            ((AbstractMessageListenerContainer)instance).setBeanName(endpoint.getId());
        }
        if (this.pollTimeout != null) {
            ((AbstractMessageListenerContainer)instance).setPollTimeout(this.pollTimeout);
        }
        endpoint.setupListenerContainer((MessageListenerContainer)instance, this.messageConverter);
        this.initializeContainer(instance);
        return instance;
    }

    protected abstract C createContainerInstance(KafkaListenerEndpoint var1);

    protected void initializeContainer(C instance) {
    }
}

