/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.concurrent.Executor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.kafka.listener.AcknowledgingMessageListener;
import org.springframework.kafka.listener.ErrorHandler;
import org.springframework.kafka.listener.LoggingErrorHandler;
import org.springframework.kafka.listener.MessageListener;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.util.Assert;

public abstract class AbstractMessageListenerContainer<K, V>
implements MessageListenerContainer,
BeanNameAware,
SmartLifecycle {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Object lifecycleMonitor = new Object();
    private String beanName;
    private AckMode ackMode = AckMode.BATCH;
    private int ackCount;
    private long ackTime;
    private Object messageListener;
    private volatile long pollTimeout = 1000L;
    private boolean autoStartup = true;
    private int phase = 0;
    private volatile boolean running = false;
    private Executor taskExecutor;
    private ErrorHandler errorHandler = new LoggingErrorHandler();

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setMessageListener(Object messageListener) {
        Assert.isTrue((messageListener instanceof MessageListener || messageListener instanceof AcknowledgingMessageListener ? 1 : 0) != 0, (String)("Either a " + MessageListener.class.getName() + " or a " + AcknowledgingMessageListener.class.getName() + " must be provided"));
        this.messageListener = messageListener;
    }

    public Object getMessageListener() {
        return this.messageListener;
    }

    @Override
    public void setupMessageListener(Object messageListener) {
        this.setMessageListener(messageListener);
    }

    public void setAckMode(AckMode ackMode) {
        this.ackMode = ackMode;
    }

    public AckMode getAckMode() {
        return this.ackMode;
    }

    public void setPollTimeout(long pollTimeout) {
        this.pollTimeout = pollTimeout;
    }

    public long getPollTimeout() {
        return this.pollTimeout;
    }

    public void setAckCount(int count) {
        this.ackCount = count;
    }

    public int getAckCount() {
        return this.ackCount;
    }

    public void setAckTime(long millis) {
        this.ackTime = millis;
    }

    public long getAckTime() {
        return this.ackTime;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.doStart();
        }
    }

    protected abstract void doStart();

    public final void stop() {
        this.stop(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(Runnable callback) {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.doStop();
        }
        if (callback != null) {
            callback.run();
        }
    }

    protected abstract void doStop();

    protected void setRunning(boolean running) {
        this.running = running;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public int getPhase() {
        return this.phase;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public Executor getTaskExecutor() {
        return this.taskExecutor;
    }

    public void setTaskExecutor(Executor fetchTaskExecutor) {
        this.taskExecutor = fetchTaskExecutor;
    }

    public static enum AckMode {
        RECORD,
        BATCH,
        TIME,
        COUNT,
        COUNT_TIME,
        MANUAL,
        MANUAL_IMMEDIATE;

    }
}

