/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener.adapter;

import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.kafka.KafkaException;
import org.springframework.kafka.listener.MessageListener;
import org.springframework.kafka.listener.adapter.AbstractRetryingMessageListenerAdapter;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;

public class RetryingMessageListenerAdapter<K, V>
extends AbstractRetryingMessageListenerAdapter<K, V>
implements MessageListener<K, V> {
    private final MessageListener<K, V> delegate;

    public RetryingMessageListenerAdapter(MessageListener<K, V> messageListener, RetryTemplate retryTemplate) {
        this(messageListener, retryTemplate, null);
    }

    public RetryingMessageListenerAdapter(MessageListener<K, V> messageListener, RetryTemplate retryTemplate, RecoveryCallback<Void> recoveryCallback) {
        super(retryTemplate, recoveryCallback);
        Assert.notNull(messageListener, (String)"'messageListener' cannot be null");
        this.delegate = messageListener;
    }

    @Override
    public void onMessage(final ConsumerRecord<K, V> record) {
        this.getRetryTemplate().execute((RetryCallback)new RetryCallback<Void, KafkaException>(){

            public Void doWithRetry(RetryContext context) throws KafkaException {
                context.setAttribute("record", (Object)record);
                RetryingMessageListenerAdapter.this.delegate.onMessage(record);
                return null;
            }
        }, this.getRecoveryCallback());
    }
}

