/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.core;

import java.util.Map;
import org.apache.kafka.streams.KafkaClientSupplier;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.kstream.KStreamBuilder;
import org.apache.kafka.streams.processor.TopologyBuilder;
import org.apache.kafka.streams.processor.internals.DefaultKafkaClientSupplier;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.context.SmartLifecycle;
import org.springframework.kafka.KafkaException;
import org.springframework.util.Assert;

public class KStreamBuilderFactoryBean
extends AbstractFactoryBean<KStreamBuilder>
implements SmartLifecycle {
    private final StreamsConfig streamsConfig;
    private KafkaStreams kafkaStreams;
    private KafkaClientSupplier clientSupplier = new DefaultKafkaClientSupplier();
    private boolean autoStartup = true;
    private int phase = Integer.MIN_VALUE;
    private volatile boolean running;

    public KStreamBuilderFactoryBean(StreamsConfig streamsConfig) {
        Assert.notNull((Object)streamsConfig, (String)"'streamsConfig' must not be null");
        this.streamsConfig = streamsConfig;
    }

    public KStreamBuilderFactoryBean(Map<String, Object> streamsConfig) {
        Assert.notNull(streamsConfig, (String)"'streamsConfig' must not be null");
        this.streamsConfig = new StreamsConfig(streamsConfig);
    }

    public void setClientSupplier(KafkaClientSupplier clientSupplier) {
        Assert.notNull((Object)clientSupplier, (String)"'clientSupplier' must not be null");
        this.clientSupplier = clientSupplier;
    }

    public Class<?> getObjectType() {
        return KStreamBuilder.class;
    }

    protected KStreamBuilder createInstance() throws Exception {
        return new KStreamBuilder();
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void stop(Runnable callback) {
        this.stop();
        if (callback != null) {
            callback.run();
        }
    }

    public synchronized void start() {
        if (!this.running) {
            try {
                this.kafkaStreams = new KafkaStreams((TopologyBuilder)this.getObject(), this.streamsConfig, this.clientSupplier);
                this.kafkaStreams.start();
                this.running = true;
            }
            catch (Exception e) {
                throw new KafkaException("Could not start stream: ", e);
            }
        }
    }

    public synchronized void stop() {
        if (this.running) {
            try {
                if (this.kafkaStreams != null) {
                    this.kafkaStreams.close();
                    this.kafkaStreams.cleanUp();
                    this.kafkaStreams = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.running = false;
            }
        }
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return this.phase;
    }
}

