/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener.adapter;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.kafka.listener.BatchAcknowledgingMessageListener;
import org.springframework.kafka.listener.BatchMessageListener;
import org.springframework.kafka.listener.KafkaListenerErrorHandler;
import org.springframework.kafka.listener.ListenerExecutionFailedException;
import org.springframework.kafka.listener.adapter.MessagingMessageListenerAdapter;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.kafka.support.KafkaNull;
import org.springframework.kafka.support.converter.BatchMessageConverter;
import org.springframework.kafka.support.converter.BatchMessagingMessageConverter;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.GenericMessage;
import org.springframework.messaging.support.MessageBuilder;

public class BatchMessagingMessageListenerAdapter<K, V>
extends MessagingMessageListenerAdapter<K, V>
implements BatchMessageListener<K, V>,
BatchAcknowledgingMessageListener<K, V> {
    private static final Message<KafkaNull> NULL_MESSAGE = new GenericMessage((Object)KafkaNull.INSTANCE);
    private BatchMessageConverter messageConverter = new BatchMessagingMessageConverter();
    private KafkaListenerErrorHandler errorHandler;

    public BatchMessagingMessageListenerAdapter(Object bean, Method method) {
        this(bean, method, null);
    }

    public BatchMessagingMessageListenerAdapter(Object bean, Method method, KafkaListenerErrorHandler errorHandler) {
        super(bean, method);
        this.errorHandler = errorHandler;
    }

    public void setBatchMessageConverter(BatchMessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    protected final BatchMessageConverter getBatchMessageConverter() {
        return this.messageConverter;
    }

    @Override
    public void onMessage(List<ConsumerRecord<K, V>> records) {
        this.onMessage(records, (Acknowledgment)null);
    }

    @Override
    public void onMessage(List<ConsumerRecord<K, V>> records, Acknowledgment acknowledgment) {
        Message message;
        if (!this.isConsumerRecordList()) {
            if (this.isMessageList()) {
                ArrayList messages = new ArrayList(records.size());
                for (ConsumerRecord<K, V> record : records) {
                    messages.add(this.toMessagingMessage(record, acknowledgment));
                }
                message = MessageBuilder.withPayload(messages).build();
            } else {
                message = this.toMessagingMessage(records, acknowledgment);
            }
        } else {
            message = NULL_MESSAGE;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Processing [" + message + "]"));
        }
        try {
            this.invokeHandler(records, acknowledgment, message);
        }
        catch (ListenerExecutionFailedException e) {
            if (this.errorHandler != null) {
                try {
                    this.errorHandler.handleError(message, e);
                }
                catch (Exception ex) {
                    throw new ListenerExecutionFailedException(this.createMessagingErrorMessage("Listener error handler threw an exception for the incoming message", message.getPayload()), ex);
                }
            }
            throw e;
        }
    }

    protected Message<?> toMessagingMessage(List records, Acknowledgment acknowledgment) {
        return this.getBatchMessageConverter().toMessage(records, acknowledgment, this.getType());
    }
}

