/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.serialization.Serializer;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.Lifecycle;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.kafka.support.TransactionSupport;
import org.springframework.util.Assert;

public class DefaultKafkaProducerFactory<K, V>
implements ProducerFactory<K, V>,
Lifecycle,
DisposableBean {
    private static final int DEFAULT_PHYSICAL_CLOSE_TIMEOUT = 30;
    private static final Log logger = LogFactory.getLog(DefaultKafkaProducerFactory.class);
    private final Map<String, Object> configs;
    private final AtomicInteger transactionIdSuffix = new AtomicInteger();
    private final BlockingQueue<CloseSafeProducer<K, V>> cache = new LinkedBlockingQueue<CloseSafeProducer<K, V>>();
    private final Map<String, CloseSafeProducer<K, V>> consumerProducers = new HashMap<String, CloseSafeProducer<K, V>>();
    private volatile CloseSafeProducer<K, V> producer;
    private Serializer<K> keySerializer;
    private Serializer<V> valueSerializer;
    private int physicalCloseTimeout = 30;
    private String transactionIdPrefix;
    private volatile boolean running;
    private boolean producerPerConsumerPartition = true;

    public DefaultKafkaProducerFactory(Map<String, Object> configs) {
        this(configs, null, null);
    }

    public DefaultKafkaProducerFactory(Map<String, Object> configs, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        this.configs = new HashMap<String, Object>(configs);
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
    }

    public void setKeySerializer(Serializer<K> keySerializer) {
        this.keySerializer = keySerializer;
    }

    public void setValueSerializer(Serializer<V> valueSerializer) {
        this.valueSerializer = valueSerializer;
    }

    public void setPhysicalCloseTimeout(int physicalCloseTimeout) {
        this.physicalCloseTimeout = physicalCloseTimeout;
    }

    public void setTransactionIdPrefix(String transactionIdPrefix) {
        Assert.notNull((Object)transactionIdPrefix, (String)"'transactionIdPrefix' cannot be null");
        this.transactionIdPrefix = transactionIdPrefix;
    }

    public void setProducerPerConsumerPartition(boolean producerPerConsumerPartition) {
        this.producerPerConsumerPartition = producerPerConsumerPartition;
    }

    public boolean isProducerPerConsumerPartition() {
        return this.producerPerConsumerPartition;
    }

    public Map<String, Object> getConfigurationProperties() {
        return Collections.unmodifiableMap(this.configs);
    }

    @Override
    public boolean transactionCapable() {
        return this.transactionIdPrefix != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        CloseSafeProducer producer = this.producer;
        this.producer = null;
        if (producer != null) {
            producer.delegate.close((long)this.physicalCloseTimeout, TimeUnit.SECONDS);
        }
        producer = (CloseSafeProducer)this.cache.poll();
        while (producer != null) {
            try {
                producer.delegate.close((long)this.physicalCloseTimeout, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                logger.error((Object)"Exception while closing producer", (Throwable)e);
            }
            producer = (CloseSafeProducer)this.cache.poll();
        }
        Map<String, CloseSafeProducer<K, V>> map = this.consumerProducers;
        synchronized (map) {
            for (Map.Entry<String, CloseSafeProducer<K, V>> entry : this.consumerProducers.entrySet()) {
                ((CloseSafeProducer)entry.getValue()).delegate.close((long)this.physicalCloseTimeout, TimeUnit.SECONDS);
            }
            this.consumerProducers.clear();
        }
    }

    public void start() {
        this.running = true;
    }

    public void stop() {
        try {
            this.destroy();
            this.running = false;
        }
        catch (Exception e) {
            logger.error((Object)"Exception while closing producer", (Throwable)e);
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Producer<K, V> createProducer() {
        if (this.transactionIdPrefix != null) {
            if (this.producerPerConsumerPartition) {
                return this.createTransactionalProducerForPartition();
            }
            return this.createTransactionalProducer();
        }
        if (this.producer == null) {
            DefaultKafkaProducerFactory defaultKafkaProducerFactory = this;
            synchronized (defaultKafkaProducerFactory) {
                if (this.producer == null) {
                    this.producer = new CloseSafeProducer<K, V>(this.createKafkaProducer());
                }
            }
        }
        return this.producer;
    }

    protected Producer<K, V> createKafkaProducer() {
        return new KafkaProducer(this.configs, this.keySerializer, this.valueSerializer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Producer<K, V> createTransactionalProducerForPartition() {
        String suffix = TransactionSupport.getTransactionIdSuffix();
        if (suffix == null) {
            return this.createTransactionalProducer();
        }
        Map<String, CloseSafeProducer<K, V>> map = this.consumerProducers;
        synchronized (map) {
            if (!this.consumerProducers.containsKey(suffix)) {
                CloseSafeProducer<K, V> newProducer = this.doCreateTxProducer(suffix, true);
                this.consumerProducers.put(suffix, newProducer);
                return newProducer;
            }
            return this.consumerProducers.get(suffix);
        }
    }

    protected Producer<K, V> createTransactionalProducer() {
        Producer producer = (Producer)this.cache.poll();
        if (producer == null) {
            return this.doCreateTxProducer("" + this.transactionIdSuffix.getAndIncrement(), false);
        }
        return producer;
    }

    private CloseSafeProducer<K, V> doCreateTxProducer(String suffix, boolean isConsumerProducer) {
        HashMap<String, Object> configs = new HashMap<String, Object>(this.configs);
        configs.put("transactional.id", this.transactionIdPrefix + suffix);
        KafkaProducer producer = new KafkaProducer(configs, this.keySerializer, this.valueSerializer);
        producer.initTransactions();
        return new CloseSafeProducer<K, V>(producer, this.cache, isConsumerProducer ? this.consumerProducers : null, (String)configs.get("transactional.id"));
    }

    protected BlockingQueue<CloseSafeProducer<K, V>> getCache() {
        return this.cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeProducerFor(String transactionIdSuffix) {
        if (this.producerPerConsumerPartition) {
            Map<String, CloseSafeProducer<K, V>> map = this.consumerProducers;
            synchronized (map) {
                CloseSafeProducer<K, V> removed = this.consumerProducers.remove(transactionIdSuffix);
                if (removed != null) {
                    ((CloseSafeProducer)removed).delegate.close((long)this.physicalCloseTimeout, TimeUnit.SECONDS);
                }
            }
        }
    }

    protected static class CloseSafeProducer<K, V>
    implements Producer<K, V> {
        private final Producer<K, V> delegate;
        private final BlockingQueue<CloseSafeProducer<K, V>> cache;
        private final Map<String, CloseSafeProducer<K, V>> consumerProducers;
        private final String txId;
        private volatile boolean txFailed;

        CloseSafeProducer(Producer<K, V> delegate) {
            this(delegate, null, null);
            Assert.isTrue((!(delegate instanceof CloseSafeProducer) ? 1 : 0) != 0, (String)"Cannot double-wrap a producer");
        }

        CloseSafeProducer(Producer<K, V> delegate, BlockingQueue<CloseSafeProducer<K, V>> cache) {
            this(delegate, cache, null);
        }

        CloseSafeProducer(Producer<K, V> delegate, BlockingQueue<CloseSafeProducer<K, V>> cache, Map<String, CloseSafeProducer<K, V>> consumerProducers) {
            this(delegate, cache, consumerProducers, null);
        }

        CloseSafeProducer(Producer<K, V> delegate, BlockingQueue<CloseSafeProducer<K, V>> cache, Map<String, CloseSafeProducer<K, V>> consumerProducers, String txId) {
            this.delegate = delegate;
            this.cache = cache;
            this.consumerProducers = consumerProducers;
            this.txId = txId;
        }

        public Future<RecordMetadata> send(ProducerRecord<K, V> record) {
            return this.delegate.send(record);
        }

        public Future<RecordMetadata> send(ProducerRecord<K, V> record, Callback callback) {
            return this.delegate.send(record, callback);
        }

        public void flush() {
            this.delegate.flush();
        }

        public List<PartitionInfo> partitionsFor(String topic) {
            return this.delegate.partitionsFor(topic);
        }

        public Map<MetricName, ? extends Metric> metrics() {
            return this.delegate.metrics();
        }

        public void initTransactions() {
            this.delegate.initTransactions();
        }

        public void beginTransaction() throws ProducerFencedException {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("beginTransaction: " + this));
            }
            try {
                this.delegate.beginTransaction();
            }
            catch (RuntimeException e) {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)("beginTransaction failed: " + this), (Throwable)e);
                }
                this.txFailed = true;
                throw e;
            }
        }

        public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> offsets, String consumerGroupId) throws ProducerFencedException {
            this.delegate.sendOffsetsToTransaction(offsets, consumerGroupId);
        }

        public void commitTransaction() throws ProducerFencedException {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("commitTransaction: " + this));
            }
            try {
                this.delegate.commitTransaction();
            }
            catch (RuntimeException e) {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)("commitTransaction failed: " + this), (Throwable)e);
                }
                this.txFailed = true;
                throw e;
            }
        }

        public void abortTransaction() throws ProducerFencedException {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("abortTransaction: " + this));
            }
            try {
                this.delegate.abortTransaction();
            }
            catch (RuntimeException e) {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)("Abort failed: " + this), (Throwable)e);
                }
                this.txFailed = true;
                throw e;
            }
        }

        public void close() {
            this.close(0L, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close(long timeout, TimeUnit unit) {
            if (this.cache != null) {
                if (this.txFailed) {
                    if (logger.isWarnEnabled()) {
                        logger.warn((Object)("Error during transactional operation; producer removed from cache; possible cause: broker restarted during transaction: " + this));
                    }
                    if (unit == null) {
                        this.delegate.close();
                    } else {
                        this.delegate.close(timeout, unit);
                    }
                    if (this.consumerProducers != null) {
                        this.removeConsumerProducer();
                    }
                } else if (this.consumerProducers == null) {
                    CloseSafeProducer closeSafeProducer = this;
                    synchronized (closeSafeProducer) {
                        if (!this.cache.contains(this) && !this.cache.offer(this)) {
                            if (unit == null) {
                                this.delegate.close();
                            } else {
                                this.delegate.close(timeout, unit);
                            }
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeConsumerProducer() {
            Map<String, CloseSafeProducer<K, V>> map = this.consumerProducers;
            synchronized (map) {
                Iterator<Map.Entry<String, CloseSafeProducer<K, V>>> iterator = this.consumerProducers.entrySet().iterator();
                while (iterator.hasNext()) {
                    if (!iterator.next().getValue().equals(this)) continue;
                    iterator.remove();
                    break;
                }
            }
        }

        public String toString() {
            return "CloseSafeProducer [delegate=" + this.delegate + "" + (this.txId != null ? ", txId=" + this.txId : "") + "]";
        }
    }
}

