/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.util.Assert;

public class KafkaMessageHeaderAccessor
extends MessageHeaderAccessor {
    public KafkaMessageHeaderAccessor(Message<?> message) {
        super(message);
    }

    public int getBlockingRetryDeliveryAttempt() {
        Assert.state((this.getHeader("kafka_deliveryAttempt") != null ? 1 : 0) != 0, (String)"Blocking delivery attempt header not present, see ContainerProperties.setDeliveryAttemptHeader() to enable");
        Integer deliveryAttempts = this.getHeader("kafka_deliveryAttempt", Integer.class);
        return deliveryAttempts == null ? 0 : deliveryAttempts;
    }

    public int getNonBlockingRetryDeliveryAttempt() {
        return this.fromBytes("retry_topic-attempts");
    }

    private int fromBytes(String headerName) {
        byte[] header = this.getHeader(headerName, byte[].class);
        return header == null ? 1 : ByteBuffer.wrap(header).getInt();
    }

    public <T> @Nullable T getHeader(String key, Class<T> type) {
        Object value = this.getHeader(key);
        if (value == null) {
            return null;
        }
        if (!type.isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException("Incorrect type specified for header '" + key + "'. Expected [" + String.valueOf(type) + "] but actual type is [" + String.valueOf(value.getClass()) + "]");
        }
        return (T)value;
    }

    protected MessageHeaderAccessor createAccessor(Message<?> message) {
        return KafkaMessageHeaderAccessor.wrap(message);
    }

    public static KafkaMessageHeaderAccessor wrap(Message<?> message) {
        return new KafkaMessageHeaderAccessor(message);
    }
}

