/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.config;

import java.util.Collection;
import org.jspecify.annotations.Nullable;
import org.springframework.kafka.config.AbstractKafkaListenerContainerFactory;
import org.springframework.kafka.config.KafkaListenerEndpoint;
import org.springframework.kafka.listener.ConcurrentMessageListenerContainer;
import org.springframework.kafka.listener.ContainerProperties;
import org.springframework.kafka.support.TopicPartitionOffset;
import org.springframework.util.Assert;

public class ConcurrentKafkaListenerContainerFactory<K, V>
extends AbstractKafkaListenerContainerFactory<ConcurrentMessageListenerContainer<K, V>, K, V> {
    private @Nullable Integer concurrency;

    public void setConcurrency(Integer concurrency) {
        this.concurrency = concurrency;
    }

    @Override
    protected ConcurrentMessageListenerContainer<K, V> createContainerInstance(KafkaListenerEndpoint endpoint) {
        TopicPartitionOffset[] topicPartitions = endpoint.getTopicPartitionsToAssign();
        if (topicPartitions != null && topicPartitions.length > 0) {
            ContainerProperties properties = new ContainerProperties(topicPartitions);
            return new ConcurrentMessageListenerContainer(this.getConsumerFactory(), properties);
        }
        Collection<String> topics = endpoint.getTopics();
        Assert.state((topics != null ? 1 : 0) != 0, (String)"'topics' must not be null");
        if (!topics.isEmpty()) {
            ContainerProperties properties = new ContainerProperties(topics.toArray(new String[0]));
            return new ConcurrentMessageListenerContainer(this.getConsumerFactory(), properties);
        }
        ContainerProperties properties = new ContainerProperties(endpoint.getTopicPattern());
        return new ConcurrentMessageListenerContainer(this.getConsumerFactory(), properties);
    }

    @Override
    protected void initializeContainer(ConcurrentMessageListenerContainer<K, V> instance, KafkaListenerEndpoint endpoint) {
        super.initializeContainer(instance, endpoint);
        Integer conc = endpoint.getConcurrency();
        if (conc != null) {
            instance.setConcurrency(conc);
        } else if (this.concurrency != null) {
            instance.setConcurrency(this.concurrency);
        }
    }
}

