/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mobile.device;

import org.springframework.mobile.device.Device;
import org.springframework.mobile.device.DevicePlatform;
import org.springframework.mobile.device.DeviceType;

public class LiteDevice
implements Device {
    public static final LiteDevice NORMAL_INSTANCE = new LiteDevice(DeviceType.NORMAL);
    public static final LiteDevice MOBILE_INSTANCE = new LiteDevice(DeviceType.MOBILE);
    public static final LiteDevice TABLET_INSTANCE = new LiteDevice(DeviceType.TABLET);
    private final DeviceType deviceType;
    private final DevicePlatform devicePlatform;

    @Override
    public DevicePlatform getDevicePlatform() {
        return this.devicePlatform;
    }

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public LiteDevice() {
        this(DeviceType.NORMAL, DevicePlatform.UNKNOWN);
    }

    public LiteDevice(DeviceType deviceType) {
        this(deviceType, DevicePlatform.UNKNOWN);
    }

    public LiteDevice(DeviceType deviceType, DevicePlatform devicePlatform) {
        this.deviceType = deviceType;
        this.devicePlatform = devicePlatform;
    }

    @Override
    public boolean isNormal() {
        return this.deviceType == DeviceType.NORMAL;
    }

    @Override
    public boolean isMobile() {
        return this.deviceType == DeviceType.MOBILE;
    }

    @Override
    public boolean isTablet() {
        return this.deviceType == DeviceType.TABLET;
    }

    public static Device from(DeviceType deviceType, DevicePlatform devicePlatform) {
        return new LiteDevice(deviceType, devicePlatform);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[LiteDevice ");
        builder.append("type").append("=").append((Object)this.deviceType);
        builder.append("]");
        return builder.toString();
    }
}

