/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.test;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Supplier;
import org.springframework.boot.context.TypeExcludeFilter;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.modulith.test.ModuleTestExecution;

class ModuleTypeExcludeFilter
extends TypeExcludeFilter {
    private final Supplier<ModuleTestExecution> execution;

    public ModuleTypeExcludeFilter(Class<?> testClass) {
        this.execution = ModuleTestExecution.of(testClass);
    }

    public boolean match(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
        return this.execution.get().includes(metadataReader.getClassMetadata().getClassName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ModuleTypeExcludeFilter)) {
            return false;
        }
        ModuleTypeExcludeFilter that = (ModuleTypeExcludeFilter)((Object)obj);
        return Objects.equals(this.execution, that.execution);
    }

    public int hashCode() {
        return Objects.hash(this.execution);
    }
}

