/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.extender.internal.dependencies.startup;

import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContextException;
import org.springframework.core.task.TaskExecutor;
import org.springframework.osgi.context.DelegatedExecutionOsgiBundleApplicationContext;
import org.springframework.osgi.context.OsgiBundleApplicationContextExecutor;
import org.springframework.osgi.extender.internal.dependencies.startup.ContextExecutorStateAccessor;
import org.springframework.osgi.extender.internal.dependencies.startup.ContextState;
import org.springframework.osgi.extender.internal.dependencies.startup.DependencyServiceManager;
import org.springframework.osgi.extender.internal.dependencies.startup.ServiceDependency;
import org.springframework.osgi.extender.internal.util.concurrent.Counter;
import org.springframework.osgi.util.OsgiStringUtils;
import org.springframework.util.Assert;

public class DependencyWaiterApplicationContextExecutor
implements OsgiBundleApplicationContextExecutor,
ContextExecutorStateAccessor {
    private static final Log log = LogFactory.getLog((Class)DependencyWaiterApplicationContextExecutor.class);
    private final Object monitor = new Object();
    private long timeout;
    private Timer watchdog;
    private TimerTask watchdogTask;
    protected DependencyServiceManager dependencyDetector;
    protected final DelegatedExecutionOsgiBundleApplicationContext delegateContext;
    private ContextState state = ContextState.INITIALIZED;
    private TaskExecutor taskExecutor;
    private Counter monitorCounter;
    private final boolean synchronousWait;
    private final Counter waitBarrier = new Counter("syncCounterWait");

    public DependencyWaiterApplicationContextExecutor(DelegatedExecutionOsgiBundleApplicationContext delegateContext, boolean syncWait) {
        this.delegateContext = delegateContext;
        this.delegateContext.setExecutor((OsgiBundleApplicationContextExecutor)this);
        this.synchronousWait = syncWait;
    }

    public void refresh() throws BeansException, IllegalStateException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("starting first stage of refresh for " + this.getDisplayName()));
        }
        this.init();
        this.stageOne();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        Object object = this.monitor;
        synchronized (object) {
            Assert.notNull((Object)this.watchdog, (String)"watchdog timer required");
            Assert.notNull((Object)this.monitorCounter, (String)" monitorCounter required");
            if (this.state == ContextState.INTERRUPTED || this.state == ContextState.STOPPED) {
                IllegalStateException ex = new IllegalStateException("cannot refresh an interrupted/closed context");
                log.fatal((Object)ex);
                throw ex;
            }
            this.state = ContextState.INITIALIZED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stageOne() {
        boolean debug = log.isDebugEnabled();
        try {
            if (debug) {
                log.debug((Object)("Calling preRefresh on " + this.getDisplayName()));
            }
            Object object = this.monitor;
            synchronized (object) {
                if (this.state != ContextState.INITIALIZED) {
                    this.logWrongState(ContextState.INITIALIZED);
                    return;
                }
                this.state = ContextState.RESOLVING_DEPENDENCIES;
            }
            object = this.delegateContext.getMonitor();
            synchronized (object) {
                this.delegateContext.startRefresh();
            }
            if (debug) {
                log.debug((Object)"Pre-refresh completed; determining dependencies...");
            }
            Runnable task = null;
            task = this.synchronousWait ? new Runnable(){

                public void run() {
                    DependencyWaiterApplicationContextExecutor.this.waitBarrier.decrement();
                }
            } : new Runnable(){

                public void run() {
                    DependencyWaiterApplicationContextExecutor.this.stageTwo();
                }
            };
            DependencyServiceManager dl = this.createDependencyServiceListener(task);
            dl.findServiceDependencies();
            if (dl.isSatisfied()) {
                log.info((Object)("No outstanding OSGi service dependencies, completing initialization for " + this.getDisplayName()));
                this.stageTwo();
            } else {
                this.dependencyDetector = dl;
                if (debug) {
                    log.debug((Object)("Registering service dependency dependencyDetector for " + this.getDisplayName()));
                }
                this.dependencyDetector.register();
                if (this.synchronousWait) {
                    this.waitBarrier.increment();
                    if (debug) {
                        log.debug((Object)"Synchronous wait-for-dependencies; waiting...");
                    }
                    if (this.waitBarrier.waitForZero(this.timeout)) {
                        this.timeout();
                    } else {
                        this.stageTwo();
                    }
                } else {
                    this.startWatchDog();
                    if (debug) {
                        log.debug((Object)"Asynch wait-for-dependencies; ending method");
                    }
                }
            }
        }
        catch (Throwable e) {
            this.fail(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stageTwo() {
        boolean debug = log.isDebugEnabled();
        if (debug) {
            log.debug((Object)("Starting stage two for " + this.getDisplayName()));
        }
        Object object = this.monitor;
        synchronized (object) {
            if (this.state != ContextState.RESOLVING_DEPENDENCIES) {
                this.logWrongState(ContextState.RESOLVING_DEPENDENCIES);
                return;
            }
            this.stopWatchDog();
            this.state = ContextState.DEPENDENCIES_RESOLVED;
        }
        this.taskExecutor.execute((Runnable)new CompleteRefreshTask());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        boolean debug = log.isDebugEnabled();
        boolean normalShutdown = false;
        Object object = this.monitor;
        synchronized (object) {
            if (this.state.isDown()) {
                return;
            }
            if (debug) {
                log.debug((Object)("Closing appCtx for " + this.getDisplayName()));
            }
            if (this.dependencyDetector != null) {
                this.dependencyDetector.deregister();
            }
            if (this.state == ContextState.STARTED) {
                if (debug) {
                    log.debug((Object)("Shutting down normaly appCtx " + this.getDisplayName()));
                }
                this.state = ContextState.STOPPED;
                normalShutdown = true;
            } else {
                if (debug) {
                    log.debug((Object)"No need to stop context (it hasn't been started yet)");
                }
                this.state = ContextState.INTERRUPTED;
            }
        }
        try {
            object = this.delegateContext.getMonitor();
            synchronized (object) {
                if (normalShutdown) {
                    this.delegateContext.normalClose();
                }
            }
        }
        catch (Exception ex) {
            log.fatal((Object)("Could not succesfully close context " + this.delegateContext), (Throwable)ex);
        }
        finally {
            this.monitorCounter.decrement();
        }
    }

    private void fail(Throwable t) {
        this.close();
        StringBuffer buf = new StringBuffer();
        if (this.dependencyDetector == null || this.dependencyDetector.getUnsatisfiedDependencies().isEmpty()) {
            buf.append("none");
        } else {
            Iterator dependencies = this.dependencyDetector.getUnsatisfiedDependencies().iterator();
            while (dependencies.hasNext()) {
                ServiceDependency dependency = (ServiceDependency)dependencies.next();
                buf.append(dependency.toString());
                if (!dependencies.hasNext()) continue;
                buf.append(", ");
            }
        }
        StringBuffer message = new StringBuffer();
        message.append("Unable to create application context for [");
        message.append(this.getBundleSymbolicName());
        message.append("], unsatisfied dependencies: ");
        message.append(buf.toString());
        log.error((Object)message.toString(), t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeout() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.dependencyDetector != null) {
                this.dependencyDetector.deregister();
            }
            log.warn((Object)("Timeout occured before finding service dependencies for [" + this.delegateContext.getDisplayName() + "]"));
            ApplicationContextException e = new ApplicationContextException("Application context initializition for '" + OsgiStringUtils.nullSafeSymbolicName((Bundle)this.getBundle()) + "' has timed out");
            e.fillInStackTrace();
            this.fail((Throwable)e);
        }
    }

    protected DependencyServiceManager createDependencyServiceListener(Runnable task) {
        return new DependencyServiceManager(this, this.delegateContext, task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startWatchDog() {
        Object object = this.monitor;
        synchronized (object) {
            this.watchdogTask = new WatchDogTask();
            this.watchdog.schedule(this.watchdogTask, this.timeout * 1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopWatchDog() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.watchdogTask != null) {
                this.watchdogTask.cancel();
                this.watchdogTask = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeout(long timeout) {
        Object object = this.monitor;
        synchronized (object) {
            this.timeout = timeout;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTaskExecutor(TaskExecutor taskExec) {
        Object object = this.monitor;
        synchronized (object) {
            this.taskExecutor = taskExec;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextState getContextState() {
        Object object = this.monitor;
        synchronized (object) {
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bundle getBundle() {
        Object object = this.monitor;
        synchronized (object) {
            return this.delegateContext.getBundle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDisplayName() {
        Object object = this.monitor;
        synchronized (object) {
            return this.delegateContext.getDisplayName();
        }
    }

    private String getBundleSymbolicName() {
        return OsgiStringUtils.nullSafeSymbolicName((Bundle)this.getBundle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWatchdog(Timer watchdog) {
        Object object = this.monitor;
        synchronized (object) {
            this.watchdog = watchdog;
        }
    }

    private void logWrongState(ContextState expected) {
        log.error((Object)("Expecting state (" + (Object)((Object)expected) + ") not (" + (Object)((Object)this.state) + ") for context [" + this.getDisplayName() + "]; assuming an interruption and bailing out"));
    }

    public void setMonitoringCounter(Counter contextsStarted) {
        this.monitorCounter = contextsStarted;
    }

    private class CompleteRefreshTask
    implements Runnable {
        private CompleteRefreshTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean debug = log.isDebugEnabled();
            if (debug) {
                log.debug((Object)("completing refresh for " + DependencyWaiterApplicationContextExecutor.this.getDisplayName()));
            }
            Object object = DependencyWaiterApplicationContextExecutor.this.monitor;
            synchronized (object) {
                if (DependencyWaiterApplicationContextExecutor.this.state != ContextState.DEPENDENCIES_RESOLVED) {
                    DependencyWaiterApplicationContextExecutor.this.logWrongState(ContextState.DEPENDENCIES_RESOLVED);
                    return;
                }
                DependencyWaiterApplicationContextExecutor.this.state = ContextState.STARTED;
            }
            object = DependencyWaiterApplicationContextExecutor.this.delegateContext.getMonitor();
            synchronized (object) {
                DependencyWaiterApplicationContextExecutor.this.delegateContext.completeRefresh();
            }
        }
    }

    private class WatchDogTask
    extends TimerTask {
        private WatchDogTask() {
        }

        public void run() {
            DependencyWaiterApplicationContextExecutor.this.timeout();
        }
    }
}

