/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.extender.internal.dependencies.startup;

import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceEvent;
import org.springframework.osgi.util.OsgiServiceReferenceUtils;

public class ServiceDependency {
    protected final Filter filter;
    protected final String filterAsString;
    protected final boolean isMandatory;
    protected final BundleContext bundleContext;

    public ServiceDependency(BundleContext bc, Filter serviceFilter, boolean isMandatory) {
        this.filter = serviceFilter;
        this.filterAsString = this.filter.toString();
        this.isMandatory = isMandatory;
        this.bundleContext = bc;
    }

    public boolean matches(ServiceEvent event) {
        return this.filter.match(event.getServiceReference());
    }

    public boolean isServicePresent() {
        return !this.isMandatory || OsgiServiceReferenceUtils.isServicePresent((BundleContext)this.bundleContext, (String)this.filterAsString);
    }

    public String toString() {
        return "Dependency on [" + this.filterAsString + "]";
    }

    public Filter getFilter() {
        return this.filter;
    }
}

