/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.test.platform;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.felix.framework.Felix;
import org.apache.felix.main.Main;
import org.osgi.framework.BundleContext;
import org.springframework.osgi.test.internal.util.IOUtils;
import org.springframework.osgi.test.platform.AbstractOsgiPlatform;
import org.springframework.util.ReflectionUtils;

public class FelixPlatform
extends AbstractOsgiPlatform {
    private static final String BUNDLE_CONTEXT_METHOD = "getBundleContext";
    private static final String FELIX_PRIVATE_FIELD = "m_felix";
    private static final Log log = LogFactory.getLog((Class)FelixPlatform.class);
    private static final String FELIX_PROFILE_DIR_PROPERTY = "felix.cache.profiledir";
    private BundleContext context;
    private Felix platform;
    private File felixStorageDir;

    public FelixPlatform() {
        this.toString = "Felix OSGi Platform";
    }

    Properties getPlatformProperties() {
        Properties props = new Properties();
        this.createStorageDir(props);
        props.put("felix.log.level", "0");
        props.put("felix.embedded.execution", "true");
        return props;
    }

    public BundleContext getBundleContext() {
        return this.context;
    }

    private void createStorageDir(Properties configProperties) {
        if (this.felixStorageDir == null) {
            this.felixStorageDir = this.createTempDir("felix");
            this.felixStorageDir.deleteOnExit();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Felix storage dir is " + this.felixStorageDir.getAbsolutePath()));
            }
        }
        configProperties.setProperty(FELIX_PROFILE_DIR_PROPERTY, this.felixStorageDir.getAbsolutePath());
    }

    public void start() throws Exception {
        if (this.platform == null) {
            System.getProperties().putAll((Map<?, ?>)this.getPlatformProperties());
            Main.main((String[])new String[0]);
            Field field = Main.class.getDeclaredField(FELIX_PRIVATE_FIELD);
            ReflectionUtils.makeAccessible((Field)field);
            this.platform = (Felix)field.get(Main.class);
            Method getContext = this.platform.getClass().getDeclaredMethod(BUNDLE_CONTEXT_METHOD, null);
            ReflectionUtils.makeAccessible((Method)getContext);
            this.context = (BundleContext)getContext.invoke((Object)this.platform, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        if (this.platform != null) {
            try {
                this.platform.stop();
            }
            finally {
                this.context = null;
                this.platform = null;
                IOUtils.delete(this.felixStorageDir);
            }
        }
    }
}

