/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.test.provisioning.internal;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.xml.DefaultDocumentLoader;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class MavenPackagedArtifactFinder {
    private static final Log log = LogFactory.getLog((Class)MavenPackagedArtifactFinder.class);
    private static final String POM_XML = "pom.xml";
    private static final String TARGET = "target";
    private static final String GROUP_ID_ELEM = "groupId";
    private final String artifactName;
    private final String groupId;

    public MavenPackagedArtifactFinder(String groupId, String artifactId, String version, String type) {
        this.groupId = groupId;
        this.artifactName = artifactId + "-" + version + "." + type;
    }

    File findPackagedArtifact(File startingDirectory) throws IOException {
        File found;
        if (!this.isMavenProjectDirectory(startingDirectory)) {
            throw new IllegalStateException(startingDirectory + " does not contain a pom.xml file");
        }
        File rootMavenProjectDir = this.findRootMavenProjectDir(startingDirectory.getCanonicalFile());
        if (log.isTraceEnabled()) {
            log.trace((Object)("Starting local artifact search from " + rootMavenProjectDir.getAbsolutePath()));
        }
        if ((found = this.findInDirectoryTree(this.artifactName, rootMavenProjectDir)) == null) {
            throw new FileNotFoundException("Cannot find the artifact <" + this.artifactName + "> with groupId <" + this.groupId + ">");
        }
        return found;
    }

    private boolean isMavenProjectDirectory(File dir) {
        return dir.isDirectory() && new File(dir, POM_XML).exists();
    }

    String getGroupIdFromPom(Resource pomXml) {
        block5: {
            try {
                DefaultDocumentLoader docLoader = new DefaultDocumentLoader();
                Document document = docLoader.loadDocument(new InputSource(pomXml.getInputStream()), null, null, 0, false);
                String groupId = DomUtils.getChildElementValueByTagName((Element)document.getDocumentElement(), (String)GROUP_ID_ELEM);
                if (groupId == null) {
                    Element parent;
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"No groupId defined; checking for the parent definition");
                    }
                    if ((parent = DomUtils.getChildElementByTagName((Element)document.getDocumentElement(), (String)"parent")) != null) {
                        return DomUtils.getChildElementValueByTagName((Element)parent, (String)GROUP_ID_ELEM);
                    }
                    break block5;
                }
                return groupId;
            }
            catch (Exception ex) {
                throw new RuntimeException(new ParserConfigurationException("error parsing resource=" + pomXml).initCause(ex));
            }
        }
        throw new IllegalArgumentException("no groupId or parent/groupId defined by resource [" + pomXml.getDescription() + "]");
    }

    private File findRootMavenProjectDir(File dir) {
        File lastFoundMavenProjectDir = dir;
        File parentDir = dir.getParentFile();
        while (this.isMavenProjectDirectory(parentDir)) {
            lastFoundMavenProjectDir = parentDir;
            parentDir = parentDir.getParentFile();
        }
        return lastFoundMavenProjectDir;
    }

    private File findInDirectoryTree(String fileName, File root) {
        File artifact;
        boolean trace = log.isTraceEnabled();
        File targetDir = new File(root, TARGET);
        if (targetDir.exists() && (artifact = new File(targetDir, fileName)).exists()) {
            if (trace) {
                log.trace((Object)("Found artifact at " + artifact.getAbsolutePath() + "; checking the pom.xml groupId..."));
            }
            File pomXml = new File(root, POM_XML);
            String groupId = this.getGroupIdFromPom((Resource)new FileSystemResource(pomXml));
            if (trace) {
                log.trace((Object)("Pom [" + pomXml.getAbsolutePath() + "] has groupId [" + groupId + "]"));
            }
            if (this.groupId.equals(groupId)) {
                return artifact;
            }
        }
        File[] children = root.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                if (!MavenPackagedArtifactFinder.this.isMavenProjectDirectory(pathname)) {
                    return false;
                }
                if (pathname.getName().equals(MavenPackagedArtifactFinder.TARGET)) {
                    return false;
                }
                if (pathname.getName().equals("src")) {
                    return false;
                }
                return !pathname.getName().equals(".svn");
            }
        });
        for (int i = 0; i < children.length; ++i) {
            File found = this.findInDirectoryTree(fileName, children[i]);
            if (found == null) continue;
            return found;
        }
        return null;
    }
}

