/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.config;

import java.util.Arrays;
import java.util.List;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.restdocs.config.AbstractConfigurer;
import org.springframework.restdocs.config.RestDocumentationContext;
import org.springframework.restdocs.config.SnippetConfigurer;
import org.springframework.restdocs.config.UriConfigurer;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.setup.ConfigurableMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcConfigurerAdapter;
import org.springframework.util.StringUtils;
import org.springframework.web.context.WebApplicationContext;

public class RestDocumentationConfigurer
extends MockMvcConfigurerAdapter {
    private final UriConfigurer uriConfigurer = new UriConfigurer(this);
    private final SnippetConfigurer snippetConfigurer = new SnippetConfigurer(this);
    private final RequestPostProcessor requestPostProcessor = new ConfigurerApplyingRequestPostProcessor(Arrays.asList(this.uriConfigurer, this.snippetConfigurer, new StepCountConfigurer(), new ContentLengthHeaderConfigurer()));

    public UriConfigurer uris() {
        return this.uriConfigurer;
    }

    public SnippetConfigurer snippets() {
        return this.snippetConfigurer;
    }

    public RequestPostProcessor beforeMockMvcCreated(ConfigurableMockMvcBuilder<?> builder, WebApplicationContext context) {
        return this.requestPostProcessor;
    }

    private static class ConfigurerApplyingRequestPostProcessor
    implements RequestPostProcessor {
        private final List<AbstractConfigurer> configurers;

        private ConfigurerApplyingRequestPostProcessor(List<AbstractConfigurer> configurers) {
            this.configurers = configurers;
        }

        public MockHttpServletRequest postProcessRequest(MockHttpServletRequest request) {
            for (AbstractConfigurer configurer : this.configurers) {
                configurer.apply(request);
            }
            return request;
        }
    }

    private static class ContentLengthHeaderConfigurer
    extends AbstractConfigurer {
        private ContentLengthHeaderConfigurer() {
        }

        @Override
        void apply(MockHttpServletRequest request) {
            long contentLength = request.getContentLengthLong();
            if (contentLength > 0L && !StringUtils.hasText((String)request.getHeader("Content-Length"))) {
                request.addHeader("Content-Length", (Object)request.getContentLengthLong());
            }
        }
    }

    private static class StepCountConfigurer
    extends AbstractConfigurer {
        private StepCountConfigurer() {
        }

        @Override
        void apply(MockHttpServletRequest request) {
            RestDocumentationContext currentContext = RestDocumentationContext.currentContext();
            if (currentContext != null) {
                currentContext.getAndIncrementStepCount();
            }
        }
    }
}

