/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth.config;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.access.ConfigAttributeEditor;
import org.springframework.security.oauth.consumer.CoreOAuthConsumerSupport;
import org.springframework.security.oauth.consumer.OAuthConsumerContextFilter;
import org.springframework.security.oauth.consumer.OAuthConsumerProcessingFilter;
import org.springframework.security.web.access.AccessDeniedHandlerImpl;
import org.springframework.security.web.access.intercept.DefaultFilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.RequestKey;
import org.springframework.security.web.util.AntUrlPathMatcher;
import org.springframework.security.web.util.RegexUrlPathMatcher;
import org.springframework.security.web.util.UrlMatcher;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuthConsumerBeanDefinitionParser
implements BeanDefinitionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        String redirectStrategyRef;
        String rememberMeServicesRef;
        BeanDefinitionBuilder consumerContextFilterBean = BeanDefinitionBuilder.rootBeanDefinition(OAuthConsumerContextFilter.class);
        String failureHandlerRef = element.getAttribute("failure-handler-ref");
        if (StringUtils.hasText((String)failureHandlerRef)) {
            consumerContextFilterBean.addPropertyReference("OAuthFailureHandler", failureHandlerRef);
        } else {
            String failurePage = element.getAttribute("oauth-failure-page");
            if (StringUtils.hasText((String)failurePage)) {
                AccessDeniedHandlerImpl failureHandler = new AccessDeniedHandlerImpl();
                failureHandler.setErrorPage(failurePage);
                consumerContextFilterBean.addPropertyValue("OAuthFailureHandler", (Object)failureHandler);
            }
        }
        String resourceDetailsRef = element.getAttribute("resource-details-service-ref");
        String supportRef = element.getAttribute("support-ref");
        if (!StringUtils.hasText((String)supportRef)) {
            BeanDefinitionBuilder consumerSupportBean = BeanDefinitionBuilder.rootBeanDefinition(CoreOAuthConsumerSupport.class);
            if (StringUtils.hasText((String)resourceDetailsRef)) {
                consumerSupportBean.addPropertyReference("protectedResourceDetailsService", resourceDetailsRef);
            }
            parserContext.getRegistry().registerBeanDefinition("oauthConsumerSupport", (BeanDefinition)consumerSupportBean.getBeanDefinition());
            supportRef = "oauthConsumerSupport";
        }
        consumerContextFilterBean.addPropertyReference("consumerSupport", supportRef);
        String tokenServicesFactoryRef = element.getAttribute("token-services-ref");
        if (StringUtils.hasText((String)tokenServicesFactoryRef)) {
            consumerContextFilterBean.addPropertyReference("tokenServices", tokenServicesFactoryRef);
        }
        if (StringUtils.hasText((String)(rememberMeServicesRef = element.getAttribute("remember-me-services-ref")))) {
            consumerContextFilterBean.addPropertyReference("rememberMeServices", rememberMeServicesRef);
        }
        if (StringUtils.hasText((String)(redirectStrategyRef = element.getAttribute("redirect-strategy-ref")))) {
            consumerContextFilterBean.addPropertyReference("redirectStrategy", redirectStrategyRef);
        }
        parserContext.getRegistry().registerBeanDefinition("oauthConsumerContextFilter", (BeanDefinition)consumerContextFilterBean.getBeanDefinition());
        BeanDefinition filterChainProxy = parserContext.getRegistry().getBeanDefinition("org.springframework.security.filterChainProxy");
        Map filterChainMap = (Map)filterChainProxy.getPropertyValues().getPropertyValue("filterChainMap").getValue();
        List<BeanMetadataElement> filterChain = this.findFilterChain(filterChainMap);
        filterChain.add(filterChain.size(), (BeanMetadataElement)new RuntimeBeanReference("oauthConsumerContextFilter"));
        List filterPatterns = DomUtils.getChildElementsByTagName((Element)element, (String)"url");
        if (!filterPatterns.isEmpty()) {
            boolean useLowerCasePaths;
            String lowercaseComparisons;
            String patternType;
            String requireAuthenticated;
            BeanDefinitionBuilder consumerAccessFilterBean = BeanDefinitionBuilder.rootBeanDefinition(OAuthConsumerProcessingFilter.class);
            if (StringUtils.hasText((String)resourceDetailsRef)) {
                consumerAccessFilterBean.addPropertyReference("protectedResourceDetailsService", resourceDetailsRef);
            }
            if (StringUtils.hasText((String)(requireAuthenticated = element.getAttribute("requireAuthenticated")))) {
                consumerAccessFilterBean.addPropertyValue("requireAuthenticated", (Object)requireAuthenticated);
            }
            if (!StringUtils.hasText((String)(patternType = element.getAttribute("path-type")))) {
                patternType = "ant";
            }
            boolean useRegex = patternType.equals("regex");
            AntUrlPathMatcher matcher = new AntUrlPathMatcher();
            if (useRegex) {
                matcher = new RegexUrlPathMatcher();
            }
            if (!StringUtils.hasText((String)(lowercaseComparisons = element.getAttribute("lowercase-comparisons")))) {
                lowercaseComparisons = null;
            }
            if ("true".equals(lowercaseComparisons)) {
                if (useRegex) {
                    ((RegexUrlPathMatcher)matcher).setRequiresLowerCaseUrl(true);
                }
            } else if ("false".equals(lowercaseComparisons) && !useRegex) {
                matcher.setRequiresLowerCaseUrl(false);
            }
            LinkedHashMap<RequestKey, Object> invocationDefinitionMap = new LinkedHashMap<RequestKey, Object>();
            Iterator filterPatternIt = filterPatterns.iterator();
            ConfigAttributeEditor editor = new ConfigAttributeEditor();
            boolean bl = useLowerCasePaths = matcher instanceof AntUrlPathMatcher && matcher.requiresLowerCaseUrl();
            while (filterPatternIt.hasNext()) {
                String access;
                String method;
                Element filterPattern = (Element)filterPatternIt.next();
                String path = filterPattern.getAttribute("pattern");
                if (!StringUtils.hasText((String)path)) {
                    parserContext.getReaderContext().error("pattern attribute cannot be empty or null", (Object)filterPattern);
                }
                if (useLowerCasePaths) {
                    path = path.toLowerCase();
                }
                if (!StringUtils.hasText((String)(method = filterPattern.getAttribute("httpMethod")))) {
                    method = null;
                }
                if (!StringUtils.hasText((String)(access = filterPattern.getAttribute("resources")))) continue;
                editor.setAsText(access);
                invocationDefinitionMap.put(new RequestKey(path, method), editor.getValue());
            }
            DefaultFilterInvocationSecurityMetadataSource source = new DefaultFilterInvocationSecurityMetadataSource((UrlMatcher)matcher, invocationDefinitionMap);
            source.setStripQueryStringFromUrls(true);
            consumerAccessFilterBean.addPropertyValue("objectDefinitionSource", (Object)source);
            parserContext.getRegistry().registerBeanDefinition("oauthConsumerFilter", (BeanDefinition)consumerAccessFilterBean.getBeanDefinition());
            filterChain.add(filterChain.size(), (BeanMetadataElement)new RuntimeBeanReference("oauthConsumerFilter"));
        }
        return null;
    }

    protected List<BeanMetadataElement> findFilterChain(Map filterChainMap) {
        Iterator valuesIt = filterChainMap.values().iterator();
        while (valuesIt.hasNext()) {
            List filterChain = (List)valuesIt.next();
            if (valuesIt.hasNext()) continue;
            return filterChain;
        }
        return null;
    }
}

