/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.consumer;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.security.core.SpringSecurityMessageSource;
import org.springframework.security.oauth2.common.DefaultThrowableAnalyzer;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.consumer.OAuth2AccessDeniedException;
import org.springframework.security.oauth2.consumer.OAuth2AccessTokenRequiredException;
import org.springframework.security.oauth2.consumer.OAuth2ProfileChain;
import org.springframework.security.oauth2.consumer.OAuth2ProfileManager;
import org.springframework.security.oauth2.consumer.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.consumer.OAuth2SecurityContextHolder;
import org.springframework.security.oauth2.consumer.OAuth2SecurityContextImpl;
import org.springframework.security.oauth2.consumer.UserRedirectRequiredException;
import org.springframework.security.oauth2.consumer.rememberme.HttpSessionOAuth2RememberMeServices;
import org.springframework.security.oauth2.consumer.rememberme.OAuth2RememberMeServices;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.PortResolver;
import org.springframework.security.web.PortResolverImpl;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.util.ThrowableAnalyzer;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.util.Assert;

public class OAuth2ClientContextFilter
implements Filter,
InitializingBean,
MessageSourceAware {
    protected MessageSourceAccessor messages = SpringSecurityMessageSource.getAccessor();
    private OAuth2ProfileManager profileManager = new OAuth2ProfileChain();
    private OAuth2RememberMeServices rememberMeServices = new HttpSessionOAuth2RememberMeServices();
    private PortResolver portResolver = new PortResolverImpl();
    private ThrowableAnalyzer throwableAnalyzer = new DefaultThrowableAnalyzer();
    private RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.profileManager, (String)"An OAuth2 profile manager must be supplied.");
        Assert.notNull((Object)this.rememberMeServices, (String)"RememberMeOAuth2TokenServices must be supplied.");
        Assert.notNull((Object)this.redirectStrategy, (String)"A redirect strategy must be supplied.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        OAuth2SecurityContextImpl oauth2Context = new OAuth2SecurityContextImpl();
        oauth2Context.setDetails(request);
        Map<String, OAuth2AccessToken> accessTokens = this.getRememberMeServices().loadRememberedTokens(request, response);
        accessTokens = accessTokens == null ? new HashMap<String, OAuth2AccessToken>() : new HashMap<String, OAuth2AccessToken>(accessTokens);
        oauth2Context.setAccessTokens(Collections.unmodifiableMap(accessTokens));
        if (request.getParameter("error") != null) {
            HashMap<String, String> errorParams = new HashMap<String, String>();
            Enumeration parameterNames = request.getParameterNames();
            while (parameterNames.hasMoreElements()) {
                String param = (String)parameterNames.nextElement();
                errorParams.put(param, request.getParameter(param));
            }
            oauth2Context.setErrorParameters(errorParams);
        }
        oauth2Context.setVerificationCode(request.getParameter("code"));
        oauth2Context.setUserAuthorizationRedirectUri(this.calculateCurrentUri(request));
        oauth2Context.setPreservedState(this.getRememberMeServices().loadPreservedState(request.getParameter("state"), request, response));
        OAuth2SecurityContextHolder.setContext(oauth2Context);
        try {
            try {
                chain.doFilter(servletRequest, servletResponse);
                return;
            }
            catch (Exception ex) {
                OAuth2ProtectedResourceDetails resourceThatNeedsAuthorization = this.checkForResourceThatNeedsAuthorization(ex);
                String neededResourceId = resourceThatNeedsAuthorization.getId();
                accessTokens.remove(neededResourceId);
                while (!accessTokens.containsKey(neededResourceId)) {
                    OAuth2AccessToken accessToken;
                    try {
                        accessToken = this.getProfileManager().obtainAccessToken(resourceThatNeedsAuthorization);
                        if (accessToken == null) {
                            throw new IllegalStateException("Profile manager returned a null access token, which is illegal according to the contract.");
                        }
                    }
                    catch (UserRedirectRequiredException e) {
                        this.redirectUser(e, request, response);
                        OAuth2SecurityContextHolder.setContext(null);
                        this.getRememberMeServices().rememberTokens(accessTokens, request, response);
                        return;
                    }
                    try {
                        accessTokens.put(neededResourceId, accessToken);
                        try {
                            if (response.isCommitted()) throw new IllegalStateException("Unable to reprocess filter chain with needed OAuth2 resources because the response is already committed.");
                            chain.doFilter((ServletRequest)request, (ServletResponse)response);
                        }
                        catch (Exception e1) {
                            resourceThatNeedsAuthorization = this.checkForResourceThatNeedsAuthorization(e1);
                            neededResourceId = resourceThatNeedsAuthorization.getId();
                            accessTokens.remove(neededResourceId);
                        }
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                        return;
                    }
                }
            }
        }
        finally {
            OAuth2SecurityContextHolder.setContext(null);
            this.getRememberMeServices().rememberTokens(accessTokens, request, response);
        }
    }

    protected void redirectUser(UserRedirectRequiredException e, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (e.getStateToPreserve() != null) {
            this.getRememberMeServices().preserveState(e.getStateKey(), e.getStateToPreserve(), request, response);
        }
        try {
            String redirectUri = e.getRedirectUri();
            StringBuilder builder = new StringBuilder(redirectUri);
            Map<String, String> requestParams = e.getRequestParams();
            int appendChar = redirectUri.indexOf(63) < 0 ? 63 : 38;
            for (Map.Entry<String, String> param : requestParams.entrySet()) {
                builder.append((char)appendChar).append(param.getKey()).append('=').append(URLEncoder.encode(param.getValue(), "UTF-8"));
                appendChar = 38;
            }
            request.setAttribute("org.springframework.security.oauth2.consumer.UserRedirectRequiredException", (Object)e);
            this.redirectStrategy.sendRedirect(request, response, builder.toString());
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalStateException(uee);
        }
    }

    protected OAuth2ProtectedResourceDetails checkForResourceThatNeedsAuthorization(Exception ex) throws ServletException, IOException {
        OAuth2ProtectedResourceDetails resourceThatNeedsAuthorization;
        Throwable[] causeChain = this.getThrowableAnalyzer().determineCauseChain((Throwable)ex);
        OAuth2AccessTokenRequiredException ase = (OAuth2AccessTokenRequiredException)((Object)this.getThrowableAnalyzer().getFirstThrowableOfType(OAuth2AccessTokenRequiredException.class, causeChain));
        if (ase != null) {
            resourceThatNeedsAuthorization = ase.getResource();
            if (resourceThatNeedsAuthorization == null) {
                throw new OAuth2AccessDeniedException(ase.getMessage());
            }
        } else {
            if (ex instanceof ServletException) {
                throw (ServletException)ex;
            }
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
        return resourceThatNeedsAuthorization;
    }

    protected String calculateCurrentUri(HttpServletRequest request) throws UnsupportedEncodingException {
        StringBuilder queryBuilder = new StringBuilder();
        Enumeration paramNames = request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String name = (String)paramNames.nextElement();
            if (!"code".equals(name)) {
                String[] parameterValues = request.getParameterValues(name);
                if (parameterValues.length == 0) {
                    queryBuilder.append(URLEncoder.encode(name, "UTF-8"));
                } else {
                    for (int i = 0; i < parameterValues.length; ++i) {
                        String parameterValue = parameterValues[i];
                        queryBuilder.append(URLEncoder.encode(name, "UTF-8")).append('=').append(URLEncoder.encode(parameterValue, "UTF-8"));
                        if (i + 1 >= parameterValues.length) continue;
                        queryBuilder.append('&');
                    }
                }
            }
            if (!paramNames.hasMoreElements()) continue;
            queryBuilder.append('&');
        }
        return UrlUtils.buildFullRequestUrl((String)request.getScheme(), (String)request.getServerName(), (int)this.getPortResolver().getServerPort((ServletRequest)request), (String)request.getRequestURI(), (String)(queryBuilder.length() > 0 ? queryBuilder.toString() : null));
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messages = new MessageSourceAccessor(messageSource);
    }

    public OAuth2ProfileManager getProfileManager() {
        return this.profileManager;
    }

    public void setProfileManager(OAuth2ProfileManager profileManager) {
        this.profileManager = profileManager;
    }

    public OAuth2RememberMeServices getRememberMeServices() {
        return this.rememberMeServices;
    }

    public void setRememberMeServices(OAuth2RememberMeServices rememberMeServices) {
        this.rememberMeServices = rememberMeServices;
    }

    public ThrowableAnalyzer getThrowableAnalyzer() {
        return this.throwableAnalyzer;
    }

    public void setThrowableAnalyzer(ThrowableAnalyzer throwableAnalyzer) {
        this.throwableAnalyzer = throwableAnalyzer;
    }

    public PortResolver getPortResolver() {
        return this.portResolver;
    }

    public void setPortResolver(PortResolver portResolver) {
        this.portResolver = portResolver;
    }

    public RedirectStrategy getRedirectStrategy() {
        return this.redirectStrategy;
    }

    public void setRedirectStrategy(RedirectStrategy redirectStrategy) {
        this.redirectStrategy = redirectStrategy;
    }
}

