/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.consumer.webserver;

import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.consumer.OAuth2AccessTokenSupport;
import org.springframework.security.oauth2.consumer.OAuth2Profile;
import org.springframework.security.oauth2.consumer.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.consumer.OAuth2SecurityContext;
import org.springframework.security.oauth2.consumer.OAuth2SecurityContextHolder;
import org.springframework.security.oauth2.consumer.UserRedirectRequiredException;
import org.springframework.security.oauth2.consumer.webserver.WebServerProfileResourceDetails;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class WebServerProfile
extends OAuth2AccessTokenSupport
implements OAuth2Profile {
    public OAuth2AccessToken obtainNewAccessToken(OAuth2ProtectedResourceDetails details) throws UserRedirectRequiredException, AccessDeniedException {
        Object state;
        WebServerProfileResourceDetails resource = (WebServerProfileResourceDetails)details;
        OAuth2SecurityContext context = OAuth2SecurityContextHolder.getContext();
        String verificationCode = null;
        if (context != null) {
            verificationCode = context.getVerificationCode();
        }
        if (context != null && context.getErrorParameters() != null) {
            throw this.getSerializationService().deserializeError(context.getErrorParameters());
        }
        if (verificationCode == null) {
            String stateKey;
            TreeMap<String, String> requestParameters = new TreeMap<String, String>();
            requestParameters.put("response_type", "code");
            requestParameters.put("client_id", resource.getClientId());
            String redirectUri = resource.getPreEstablishedRedirectUri();
            if (redirectUri == null) {
                if (context == null) {
                    throw new IllegalStateException("No OAuth 2 security context has been established: unable to determine the redirect URI for the current context.");
                }
                redirectUri = context.getUserAuthorizationRedirectUri();
                if (redirectUri == null) {
                    throw new IllegalStateException("No redirect URI has been established for the current OAuth 2 security context.");
                }
                requestParameters.put("redirect_uri", redirectUri);
            } else {
                redirectUri = null;
            }
            if (resource.isScoped()) {
                StringBuilder builder = new StringBuilder();
                List<String> scope = resource.getScope();
                if (scope != null) {
                    Iterator<String> scopeIt = scope.iterator();
                    while (scopeIt.hasNext()) {
                        builder.append(scopeIt.next());
                        if (!scopeIt.hasNext()) continue;
                        builder.append(' ');
                    }
                }
                requestParameters.put("scope", builder.toString());
            }
            if ((stateKey = resource.getState()) != null) {
                requestParameters.put("state", stateKey);
            }
            UserRedirectRequiredException redirectException = new UserRedirectRequiredException(resource.getUserAuthorizationUri(), requestParameters);
            if (redirectUri != null) {
                redirectException.setStateKey(resource.getState());
                redirectException.setStateToPreserve(redirectUri);
            }
            throw redirectException;
        }
        LinkedMultiValueMap form = new LinkedMultiValueMap();
        form.add((Object)"grant_type", (Object)"authorization_code");
        form.add((Object)"client_id", (Object)resource.getClientId());
        form.add((Object)"code", (Object)verificationCode);
        Object object = state = context == null ? null : context.getPreservedState();
        if (state == null) {
            state = resource.getPreEstablishedRedirectUri();
        }
        if (state == null) {
            state = context == null ? null : context.getUserAuthorizationRedirectUri();
        }
        form.add((Object)"redirect_uri", (Object)String.valueOf(state));
        return this.retrieveToken((MultiValueMap<String, String>)form, resource);
    }

    public boolean supportsResource(OAuth2ProtectedResourceDetails resource) {
        return resource instanceof WebServerProfileResourceDetails && "authorization_code".equals(resource.getGrantType());
    }
}

