/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.client;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.client.ClientCredentialsAuthenticationToken;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientCredentialsAuthenticationProvider
implements AuthenticationProvider,
InitializingBean {
    private AuthenticationManager authenticationManager;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.authenticationManager, (String)"An authentication manager must be provided.");
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        ClientCredentialsAuthenticationToken auth = (ClientCredentialsAuthenticationToken)authentication;
        Authentication clientAuth = this.getAuthenticationManager().authenticate((Authentication)auth.getClientAuthentication());
        return new OAuth2Authentication<Authentication, Object>(clientAuth, null);
    }

    public boolean supports(Class<?> authentication) {
        return ClientCredentialsAuthenticationToken.class.isAssignableFrom(authentication);
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    @Autowired
    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }
}

