/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.password;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.password.ClientPasswordAuthenticationToken;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientPasswordAuthenticationProvider
implements AuthenticationProvider,
InitializingBean {
    private AuthenticationManager authenticationManager;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.authenticationManager, (String)"An authentication manager must be provided.");
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        ClientPasswordAuthenticationToken auth = (ClientPasswordAuthenticationToken)authentication;
        Authentication clientAuth = this.getAuthenticationManager().authenticate((Authentication)auth.getClientAuthentication());
        Authentication userAuth = this.getAuthenticationManager().authenticate((Authentication)auth.getUserAuthentication());
        return new OAuth2Authentication<Authentication, Authentication>(clientAuth, userAuth);
    }

    public boolean supports(Class<?> authentication) {
        return ClientPasswordAuthenticationToken.class.isAssignableFrom(authentication);
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    @Autowired
    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }
}

