/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.verification;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.oauth2.provider.ClientAuthenticationToken;
import org.springframework.security.oauth2.provider.verification.ClientAuthenticationCache;
import org.springframework.security.oauth2.provider.verification.DefaultClientAuthenticationCache;
import org.springframework.security.oauth2.provider.verification.UserApprovalHandler;
import org.springframework.security.oauth2.provider.verification.VerificationCodeAuthenticationToken;
import org.springframework.web.filter.GenericFilterBean;

public class BasicUserApprovalFilter
extends GenericFilterBean
implements UserApprovalHandler {
    public static final String DEFAULT_APPROVAL_REQUEST_PARAMETER = "user_oauth_approval";
    public static final String DEFAULT_APPROVAL_PARAMETER_VALUE = "true";
    private ClientAuthenticationCache authenticationCache = new DefaultClientAuthenticationCache();
    private String approvalParameter = "user_oauth_approval";
    private String approvalParameterValue = "true";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.requiresProcessing(request)) {
            VerificationCodeAuthenticationToken authToken = this.getAuthenticationCache().getAuthentication((HttpServletRequest)request, (HttpServletResponse)response);
            if (authToken == null) {
                throw this.createIllegalApprovalRequestException();
            }
            authToken.setDenied(!this.isApproval(request));
            this.getAuthenticationCache().updateAuthentication(authToken, (HttpServletRequest)request, (HttpServletResponse)response);
        }
        chain.doFilter(request, response);
    }

    public boolean isApproved(ClientAuthenticationToken clientAuthentication) {
        return clientAuthentication.isAuthenticated();
    }

    protected boolean requiresProcessing(ServletRequest request) {
        return request.getParameterMap().containsKey(this.getApprovalParameter());
    }

    protected boolean isApproval(ServletRequest request) {
        return this.getApprovalParameterValue().equals(request.getParameter(this.getApprovalParameter()));
    }

    protected RuntimeException createIllegalApprovalRequestException() {
        return new AuthenticationServiceException(String.format("Request parameter %s may only be applied in the middle of an oauth web server approval profile.", DEFAULT_APPROVAL_REQUEST_PARAMETER));
    }

    public ClientAuthenticationCache getAuthenticationCache() {
        return this.authenticationCache;
    }

    public void setAuthenticationCache(ClientAuthenticationCache authenticationCache) {
        this.authenticationCache = authenticationCache;
    }

    public String getApprovalParameter() {
        return this.approvalParameter;
    }

    public void setApprovalParameter(String approvalParameter) {
        this.approvalParameter = approvalParameter;
    }

    public String getApprovalParameterValue() {
        return this.approvalParameterValue;
    }

    public void setApprovalParameterValue(String approvalParameterValue) {
        this.approvalParameterValue = approvalParameterValue;
    }
}

