/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth.config;

import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.oauth.common.signature.RSAKeySecret;
import org.springframework.security.oauth.common.signature.SharedConsumerSecret;
import org.springframework.security.oauth.common.signature.SignatureSecret;
import org.springframework.security.oauth.provider.BaseConsumerDetails;
import org.springframework.security.oauth.provider.ConsumerDetails;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsumerDetailsFactoryBean
implements FactoryBean<ConsumerDetails>,
ResourceLoaderAware {
    private Object typeOfSecret;
    private BaseConsumerDetails consumer = new BaseConsumerDetails();
    private String secret;
    private ResourceLoader resourceLoader;

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumer.setConsumerKey(consumerKey);
    }

    public void setConsumerName(String consumerName) {
        this.consumer.setConsumerName(consumerName);
    }

    public void setSignatureSecret(SignatureSecret signatureSecret) {
        this.consumer.setSignatureSecret(signatureSecret);
    }

    public void setAuthorities(String authorities) {
        this.consumer.setAuthorities(AuthorityUtils.commaSeparatedStringToAuthorityList((String)authorities));
    }

    public void setResourceName(String resourceName) {
        this.consumer.setResourceName(resourceName);
    }

    public void setResourceDescription(String resourceDescription) {
        this.consumer.setResourceDescription(resourceDescription);
    }

    public void setRequiredToObtainAuthenticatedToken(boolean requiredToObtainAuthenticatedToken) {
        this.consumer.setRequiredToObtainAuthenticatedToken(requiredToObtainAuthenticatedToken);
    }

    public void setTypeOfSecret(Object typeOfSecret) {
        this.typeOfSecret = typeOfSecret;
    }

    public ConsumerDetails getObject() throws Exception {
        if ("rsa-cert".equals(this.typeOfSecret)) {
            try {
                Certificate cert = CertificateFactory.getInstance("X.509").generateCertificate(this.resourceLoader.getResource(this.secret).getInputStream());
                this.consumer.setSignatureSecret(new RSAKeySecret(cert.getPublicKey()));
            }
            catch (IOException e) {
                throw new BeanCreationException("RSA certificate not found at " + this.secret + ".", (Throwable)e);
            }
            catch (CertificateException e) {
                throw new BeanCreationException("Invalid RSA certificate at " + this.secret + ".", (Throwable)e);
            }
            catch (NullPointerException e) {
                throw new BeanCreationException("Could not load RSA certificate at " + this.secret + ".", (Throwable)e);
            }
        } else {
            this.consumer.setSignatureSecret(new SharedConsumerSecret(this.secret));
        }
        return this.consumer;
    }

    public Class<?> getObjectType() {
        return BaseConsumerDetails.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

