/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth.config;

import java.util.List;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.oauth.config.ConsumerDetailsFactoryBean;
import org.springframework.security.oauth.provider.InMemoryConsumerDetailsService;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsumerServiceBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    protected Class<?> getBeanClass(Element element) {
        return InMemoryConsumerDetailsService.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        List consumerElements = DomUtils.getChildElementsByTagName((Element)element, (String)"consumer");
        ManagedMap consumers = new ManagedMap();
        for (Element item : consumerElements) {
            String requiredToObtainAuthenticatedToken;
            String resourceDescription;
            String resourceName;
            String authorities;
            BeanDefinitionBuilder consumer = BeanDefinitionBuilder.genericBeanDefinition(ConsumerDetailsFactoryBean.class);
            Element consumerElement = item;
            String key = consumerElement.getAttribute("key");
            if (StringUtils.hasText((String)key)) {
                consumer.addPropertyValue("consumerKey", (Object)key);
            } else {
                parserContext.getReaderContext().error("A consumer key must be supplied with the definition of a consumer.", (Object)consumerElement);
            }
            String secret = consumerElement.getAttribute("secret");
            if (StringUtils.hasText((String)secret)) {
                consumer.addPropertyValue("secret", (Object)secret);
                String typeOfSecret = consumerElement.getAttribute("typeOfSecret");
                consumer.addPropertyValue("typeOfSecret", (Object)typeOfSecret);
            } else {
                parserContext.getReaderContext().error("A consumer secret must be supplied with the definition of a consumer.", (Object)consumerElement);
            }
            String name = consumerElement.getAttribute("name");
            if (StringUtils.hasText((String)name)) {
                consumer.addPropertyValue("consumerName", (Object)name);
            }
            if (StringUtils.hasText((String)(authorities = consumerElement.getAttribute("authorities")))) {
                consumer.addPropertyValue("authorities", (Object)authorities);
            }
            if (StringUtils.hasText((String)(resourceName = consumerElement.getAttribute("resourceName")))) {
                consumer.addPropertyValue("resourceName", (Object)resourceName);
            }
            if (StringUtils.hasText((String)(resourceDescription = consumerElement.getAttribute("resourceDescription")))) {
                consumer.addPropertyValue("resourceDescription", (Object)resourceDescription);
            }
            if (StringUtils.hasText((String)(requiredToObtainAuthenticatedToken = consumerElement.getAttribute("requiredToObtainAuthenticatedToken")))) {
                consumer.addPropertyValue("requiredToObtainAuthenticatedToken", (Object)requiredToObtainAuthenticatedToken);
            }
            consumers.put((Object)key, (Object)consumer.getBeanDefinition());
        }
        builder.addPropertyValue("consumerDetailsStore", (Object)consumers);
    }
}

