/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth.config;

import java.util.List;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.oauth.config.ConfigUtils;
import org.springframework.security.oauth.provider.filter.AccessTokenProcessingFilter;
import org.springframework.security.oauth.provider.filter.ProtectedResourceProcessingFilter;
import org.springframework.security.oauth.provider.filter.UnauthenticatedRequestTokenProcessingFilter;
import org.springframework.security.oauth.provider.filter.UserAuthorizationProcessingFilter;
import org.springframework.security.oauth.provider.filter.UserAuthorizationSuccessfulAuthenticationHandler;
import org.springframework.security.oauth.provider.verifier.RandomValueVerifierServices;
import org.springframework.security.web.access.ExceptionTranslationFilter;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuthProviderBeanDefinitionParser
implements BeanDefinitionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        String verifierServicesRef;
        String require10a;
        String authHandlerRef;
        String supportRef;
        String nonceServicesRef;
        String accessTokenURL;
        String accessGrantedURL;
        String authenticateTokenURL;
        String requestTokenURL;
        String consumerDetailsRef = element.getAttribute("consumer-details-service-ref");
        String tokenServicesRef = element.getAttribute("token-services-ref");
        BeanDefinitionBuilder requestTokenFilterBean = BeanDefinitionBuilder.rootBeanDefinition(UnauthenticatedRequestTokenProcessingFilter.class);
        if (StringUtils.hasText((String)consumerDetailsRef)) {
            requestTokenFilterBean.addPropertyReference("consumerDetailsService", consumerDetailsRef);
        }
        if (StringUtils.hasText((String)tokenServicesRef)) {
            requestTokenFilterBean.addPropertyReference("tokenServices", tokenServicesRef);
        }
        if (StringUtils.hasText((String)(requestTokenURL = element.getAttribute("request-token-url")))) {
            requestTokenFilterBean.addPropertyValue("filterProcessesUrl", (Object)requestTokenURL);
        }
        BeanDefinitionBuilder authenticateTokenFilterBean = BeanDefinitionBuilder.rootBeanDefinition(UserAuthorizationProcessingFilter.class);
        authenticateTokenFilterBean.addPropertyReference("authenticationManager", "org.springframework.security.authenticationManager");
        if (StringUtils.hasText((String)tokenServicesRef)) {
            authenticateTokenFilterBean.addPropertyReference("tokenServices", tokenServicesRef);
        }
        if (StringUtils.hasText((String)(authenticateTokenURL = element.getAttribute("authenticate-token-url")))) {
            authenticateTokenFilterBean.addPropertyValue("filterProcessesUrl", (Object)authenticateTokenURL);
        }
        if (!StringUtils.hasText((String)(accessGrantedURL = element.getAttribute("access-granted-url")))) {
            accessGrantedURL = "/";
        }
        authenticateTokenFilterBean.addConstructorArgValue((Object)accessGrantedURL);
        BeanDefinitionBuilder simpleUrlAuthenticationFailureHandler = BeanDefinitionBuilder.rootBeanDefinition(SimpleUrlAuthenticationFailureHandler.class);
        String authenticationFailedURL = element.getAttribute("authentication-failed-url");
        if (StringUtils.hasText((String)authenticationFailedURL)) {
            simpleUrlAuthenticationFailureHandler.addConstructorArgValue((Object)authenticationFailedURL);
        } else {
            simpleUrlAuthenticationFailureHandler.addConstructorArgValue((Object)"/");
        }
        String tokenIdParam = element.getAttribute("token-id-param");
        if (StringUtils.hasText((String)tokenIdParam)) {
            authenticateTokenFilterBean.addPropertyValue("tokenIdParameterName", (Object)tokenIdParam);
        }
        BeanDefinitionBuilder accessTokenFilterBean = BeanDefinitionBuilder.rootBeanDefinition(AccessTokenProcessingFilter.class);
        if (StringUtils.hasText((String)consumerDetailsRef)) {
            accessTokenFilterBean.addPropertyReference("consumerDetailsService", consumerDetailsRef);
        }
        if (StringUtils.hasText((String)tokenServicesRef)) {
            accessTokenFilterBean.addPropertyReference("tokenServices", tokenServicesRef);
        }
        if (StringUtils.hasText((String)(accessTokenURL = element.getAttribute("access-token-url")))) {
            accessTokenFilterBean.addPropertyValue("filterProcessesUrl", (Object)accessTokenURL);
        }
        BeanDefinitionBuilder protectedResourceFilterBean = BeanDefinitionBuilder.rootBeanDefinition(ProtectedResourceProcessingFilter.class);
        if (StringUtils.hasText((String)consumerDetailsRef)) {
            protectedResourceFilterBean.addPropertyReference("consumerDetailsService", consumerDetailsRef);
        }
        if (StringUtils.hasText((String)tokenServicesRef)) {
            protectedResourceFilterBean.addPropertyReference("tokenServices", tokenServicesRef);
        }
        if (StringUtils.hasText((String)(nonceServicesRef = element.getAttribute("nonce-services-ref")))) {
            requestTokenFilterBean.addPropertyReference("nonceServices", nonceServicesRef);
            accessTokenFilterBean.addPropertyReference("nonceServices", nonceServicesRef);
            protectedResourceFilterBean.addPropertyReference("nonceServices", nonceServicesRef);
        }
        if (StringUtils.hasText((String)(supportRef = element.getAttribute("support-ref")))) {
            requestTokenFilterBean.addPropertyReference("providerSupport", supportRef);
            accessTokenFilterBean.addPropertyReference("providerSupport", supportRef);
            protectedResourceFilterBean.addPropertyReference("providerSupport", supportRef);
        }
        BeanDefinitionBuilder successfulAuthenticationHandler = BeanDefinitionBuilder.rootBeanDefinition(UserAuthorizationSuccessfulAuthenticationHandler.class);
        successfulAuthenticationHandler.addConstructorArgValue((Object)accessGrantedURL);
        String callbackUrlParam = element.getAttribute("callback-url-param");
        if (StringUtils.hasText((String)callbackUrlParam)) {
            successfulAuthenticationHandler.addPropertyValue("callbackParameterName", (Object)callbackUrlParam);
        }
        if (StringUtils.hasText((String)(authHandlerRef = element.getAttribute("auth-handler-ref")))) {
            protectedResourceFilterBean.addPropertyReference("authHandler", authHandlerRef);
        }
        if (StringUtils.hasText((String)(require10a = element.getAttribute("require10a")))) {
            requestTokenFilterBean.addPropertyValue("require10a", (Object)require10a);
            authenticateTokenFilterBean.addPropertyValue("require10a", (Object)require10a);
            accessTokenFilterBean.addPropertyValue("require10a", (Object)require10a);
            successfulAuthenticationHandler.addPropertyValue("require10a", (Object)require10a);
        }
        if (!StringUtils.hasText((String)(verifierServicesRef = element.getAttribute("verifier-services-ref")))) {
            BeanDefinitionBuilder verifierServices = BeanDefinitionBuilder.rootBeanDefinition(RandomValueVerifierServices.class);
            parserContext.getRegistry().registerBeanDefinition("oauthVerifierServices", (BeanDefinition)verifierServices.getBeanDefinition());
            verifierServicesRef = "oauthVerifierServices";
        }
        authenticateTokenFilterBean.addPropertyReference("verifierServices", verifierServicesRef);
        String oauthSuccessfulAuthenticationHandlerRef = "oauthSuccessfulAuthenticationHandler";
        parserContext.getRegistry().registerBeanDefinition(oauthSuccessfulAuthenticationHandlerRef, (BeanDefinition)successfulAuthenticationHandler.getBeanDefinition());
        authenticateTokenFilterBean.addPropertyReference("authenticationSuccessHandler", oauthSuccessfulAuthenticationHandlerRef);
        List<BeanMetadataElement> filterChain = ConfigUtils.findFilterChain(parserContext, element.getAttribute("filter-chain-ref"));
        int index = this.insertIndex(filterChain);
        parserContext.getRegistry().registerBeanDefinition("oauthRequestTokenFilter", (BeanDefinition)requestTokenFilterBean.getBeanDefinition());
        filterChain.add(index++, (BeanMetadataElement)new RuntimeBeanReference("oauthRequestTokenFilter"));
        parserContext.getRegistry().registerBeanDefinition("oauthAuthenticateTokenFilter", (BeanDefinition)authenticateTokenFilterBean.getBeanDefinition());
        filterChain.add(index++, (BeanMetadataElement)new RuntimeBeanReference("oauthAuthenticateTokenFilter"));
        parserContext.getRegistry().registerBeanDefinition("oauthAccessTokenFilter", (BeanDefinition)accessTokenFilterBean.getBeanDefinition());
        filterChain.add(index++, (BeanMetadataElement)new RuntimeBeanReference("oauthAccessTokenFilter"));
        parserContext.getRegistry().registerBeanDefinition("oauthProtectedResourceFilter", (BeanDefinition)protectedResourceFilterBean.getBeanDefinition());
        filterChain.add(index++, (BeanMetadataElement)new RuntimeBeanReference("oauthProtectedResourceFilter"));
        return null;
    }

    private int insertIndex(List<BeanMetadataElement> filterChain) {
        for (int i = 0; i < filterChain.size(); ++i) {
            String beanName;
            BeanMetadataElement filter = filterChain.get(i);
            if (!(filter instanceof BeanDefinition) || !(beanName = ((BeanDefinition)filter).getBeanClassName()).equals(ExceptionTranslationFilter.class.getName())) continue;
            return i + 1;
        }
        return filterChain.size();
    }
}

