/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth.provider.token;

import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth.provider.token.ExpiredOAuthTokenException;
import org.springframework.security.oauth.provider.token.InvalidOAuthTokenException;
import org.springframework.security.oauth.provider.token.OAuthAccessProviderToken;
import org.springframework.security.oauth.provider.token.OAuthProviderToken;
import org.springframework.security.oauth.provider.token.OAuthProviderTokenImpl;
import org.springframework.security.oauth.provider.token.OAuthProviderTokenServices;
import org.springframework.security.oauth.provider.token.OAuthTokenLifecycleListener;
import org.springframework.security.oauth.provider.token.OAuthTokenLifecycleRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RandomValueProviderTokenServices
implements OAuthProviderTokenServices,
InitializingBean,
OAuthTokenLifecycleRegistry {
    private Random random;
    private int requestTokenValiditySeconds = 600;
    private int accessTokenValiditySeconds = 43200;
    private int tokenSecretLengthBytes = 80;
    private final Collection<OAuthTokenLifecycleListener> lifecycleListeners = new HashSet<OAuthTokenLifecycleListener>();

    protected abstract OAuthProviderTokenImpl readToken(String var1);

    protected abstract void storeToken(String var1, OAuthProviderTokenImpl var2);

    protected abstract OAuthProviderTokenImpl removeToken(String var1);

    public void afterPropertiesSet() throws Exception {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
    }

    @Override
    public OAuthProviderToken getToken(String token) throws AuthenticationException {
        OAuthProviderTokenImpl tokenImpl = this.readToken(token);
        if (tokenImpl == null) {
            throw new InvalidOAuthTokenException("Invalid token: " + token);
        }
        if (this.isExpired(tokenImpl)) {
            this.removeToken(token);
            this.onTokenRemoved(tokenImpl);
            throw new ExpiredOAuthTokenException("Expired token.");
        }
        return tokenImpl;
    }

    protected boolean isExpired(OAuthProviderTokenImpl authToken) {
        return authToken.isAccessToken() ? authToken.getTimestamp() + (long)this.getAccessTokenValiditySeconds() * 1000L < System.currentTimeMillis() : authToken.getTimestamp() + (long)this.getRequestTokenValiditySeconds() * 1000L < System.currentTimeMillis();
    }

    @Override
    public OAuthProviderToken createUnauthorizedRequestToken(String consumerKey, String callbackUrl) throws AuthenticationException {
        String tokenValue = UUID.randomUUID().toString();
        byte[] secretBytes = new byte[this.getTokenSecretLengthBytes()];
        this.getRandom().nextBytes(secretBytes);
        String secret = new String(Base64.encodeBase64((byte[])secretBytes));
        OAuthProviderTokenImpl token = new OAuthProviderTokenImpl();
        token.setAccessToken(false);
        token.setConsumerKey(consumerKey);
        token.setCallbackUrl(callbackUrl);
        token.setUserAuthentication(null);
        token.setSecret(secret);
        token.setValue(tokenValue);
        token.setTimestamp(System.currentTimeMillis());
        this.onTokenCreated(token);
        this.storeToken(tokenValue, token);
        return token;
    }

    @Override
    public void authorizeRequestToken(String requestToken, String verifier, Authentication authentication) throws AuthenticationException {
        OAuthProviderTokenImpl tokenImpl = this.readToken(requestToken);
        if (tokenImpl == null) {
            throw new InvalidOAuthTokenException("Invalid token: " + requestToken);
        }
        if (this.isExpired(tokenImpl)) {
            this.removeToken(requestToken);
            this.onTokenRemoved(tokenImpl);
            throw new ExpiredOAuthTokenException("Expired token.");
        }
        if (tokenImpl.isAccessToken()) {
            throw new InvalidOAuthTokenException("Request to authorize an access token.");
        }
        tokenImpl.setUserAuthentication(authentication);
        tokenImpl.setTimestamp(System.currentTimeMillis());
        tokenImpl.setVerifier(verifier);
        this.storeToken(requestToken, tokenImpl);
    }

    @Override
    public OAuthAccessProviderToken createAccessToken(String requestToken) throws AuthenticationException {
        OAuthProviderTokenImpl tokenImpl = this.readToken(requestToken);
        if (tokenImpl == null) {
            throw new InvalidOAuthTokenException("Invalid token: " + requestToken);
        }
        if (this.isExpired(tokenImpl)) {
            this.removeToken(requestToken);
            this.onTokenRemoved(tokenImpl);
            throw new ExpiredOAuthTokenException("Expired token.");
        }
        if (tokenImpl.isAccessToken()) {
            throw new InvalidOAuthTokenException("Not a request token.");
        }
        if (tokenImpl.getUserAuthentication() == null) {
            throw new InvalidOAuthTokenException("Request token has not been authorized.");
        }
        OAuthProviderTokenImpl requestTokenImpl = this.removeToken(requestToken);
        if (requestTokenImpl != null) {
            this.onTokenRemoved(requestTokenImpl);
        }
        String tokenValue = UUID.randomUUID().toString();
        byte[] secretBytes = new byte[this.getTokenSecretLengthBytes()];
        this.getRandom().nextBytes(secretBytes);
        String secret = new String(Base64.encodeBase64((byte[])secretBytes));
        OAuthProviderTokenImpl token = new OAuthProviderTokenImpl();
        token.setAccessToken(true);
        token.setConsumerKey(tokenImpl.getConsumerKey());
        token.setUserAuthentication(tokenImpl.getUserAuthentication());
        token.setSecret(secret);
        token.setValue(tokenValue);
        token.setTimestamp(System.currentTimeMillis());
        this.onTokenCreated(token);
        this.storeToken(tokenValue, token);
        return token;
    }

    protected void onTokenRemoved(OAuthProviderTokenImpl token) {
        for (OAuthTokenLifecycleListener listener : this.getLifecycleListeners()) {
            listener.tokenExpired(token);
        }
    }

    protected void onTokenCreated(OAuthProviderTokenImpl token) {
        for (OAuthTokenLifecycleListener listener : this.getLifecycleListeners()) {
            listener.tokenCreated(token);
        }
    }

    public int getTokenSecretLengthBytes() {
        return this.tokenSecretLengthBytes;
    }

    public void setTokenSecretLengthBytes(int tokenSecretLengthBytes) {
        this.tokenSecretLengthBytes = tokenSecretLengthBytes;
    }

    public Random getRandom() {
        return this.random;
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    public int getRequestTokenValiditySeconds() {
        return this.requestTokenValiditySeconds;
    }

    public void setRequestTokenValiditySeconds(int requestTokenValiditySeconds) {
        this.requestTokenValiditySeconds = requestTokenValiditySeconds;
    }

    public int getAccessTokenValiditySeconds() {
        return this.accessTokenValiditySeconds;
    }

    public void setAccessTokenValiditySeconds(int accessTokenValiditySeconds) {
        this.accessTokenValiditySeconds = accessTokenValiditySeconds;
    }

    @Override
    public Collection<OAuthTokenLifecycleListener> getLifecycleListeners() {
        return this.lifecycleListeners;
    }

    @Override
    @Autowired(required=false)
    public void register(OAuthTokenLifecycleListener ... lifecycleListeners) {
        if (lifecycleListeners != null) {
            this.lifecycleListeners.addAll(Arrays.asList(lifecycleListeners));
        }
    }
}

