/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth.provider.attributes;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.method.AbstractFallbackMethodSecurityMetadataSource;
import org.springframework.security.oauth.provider.attributes.ConsumerKeysAllowed;
import org.springframework.security.oauth.provider.attributes.ConsumerRolesAllowed;
import org.springframework.security.oauth.provider.attributes.ConsumerSecurityConfig;
import org.springframework.security.oauth.provider.attributes.DenyAllConsumers;
import org.springframework.security.oauth.provider.attributes.PermitAllConsumers;

public class ConsumerSecurityMetadataSource
extends AbstractFallbackMethodSecurityMetadataSource {
    protected List<ConfigAttribute> findAttributes(Class<?> clazz) {
        return this.processAnnotations(clazz.getAnnotations());
    }

    protected List<ConfigAttribute> findAttributes(Method method, Class<?> targetClass) {
        return this.processAnnotations(AnnotationUtils.getAnnotations((Method)method));
    }

    public Collection<ConfigAttribute> getAllConfigAttributes() {
        return null;
    }

    private List<ConfigAttribute> processAnnotations(Annotation[] annotations) {
        if (annotations == null || annotations.length == 0) {
            return null;
        }
        ArrayList<ConfigAttribute> attributes = new ArrayList<ConfigAttribute>();
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation a = annotationArray[n2];
            if (a instanceof DenyAllConsumers) {
                attributes.add((ConfigAttribute)ConsumerSecurityConfig.DENY_ALL_ATTRIBUTE);
                return attributes;
            }
            if (a instanceof PermitAllConsumers) {
                attributes.add((ConfigAttribute)ConsumerSecurityConfig.PERMIT_ALL_ATTRIBUTE);
                return attributes;
            }
            if (a instanceof ConsumerRolesAllowed) {
                ConsumerRolesAllowed ra = (ConsumerRolesAllowed)a;
                String[] stringArray = ra.value();
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String role = stringArray[n4];
                    attributes.add((ConfigAttribute)new ConsumerSecurityConfig(role, ConsumerSecurityConfig.ConsumerSecurityType.CONSUMER_ROLE));
                    ++n4;
                }
                return attributes;
            }
            if (a instanceof ConsumerKeysAllowed) {
                ConsumerKeysAllowed ka = (ConsumerKeysAllowed)a;
                String[] stringArray = ka.value();
                int n5 = stringArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    String key = stringArray[n6];
                    attributes.add((ConfigAttribute)new ConsumerSecurityConfig(key, ConsumerSecurityConfig.ConsumerSecurityType.CONSUMER_KEY));
                    ++n6;
                }
                return attributes;
            }
            ++n2;
        }
        return null;
    }
}

