/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth.provider.verifier;

import java.security.SecureRandom;
import java.util.Random;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.oauth.provider.verifier.OAuthVerifierServices;

public class RandomValueVerifierServices
implements OAuthVerifierServices,
InitializingBean {
    private static final char[] DEFAULT_CODEC = "1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();
    private Random random;
    private int verifierLengthBytes = 6;

    public void afterPropertiesSet() throws Exception {
        if (this.getRandom() == null) {
            this.setRandom(new SecureRandom());
        }
    }

    @Override
    public String createVerifier() {
        byte[] verifierBytes = new byte[this.getVerifierLengthBytes()];
        this.getRandom().nextBytes(verifierBytes);
        return this.getVerifierString(verifierBytes);
    }

    protected String getVerifierString(byte[] verifierBytes) {
        char[] chars = new char[verifierBytes.length];
        int i = 0;
        while (i < verifierBytes.length) {
            chars[i] = DEFAULT_CODEC[(verifierBytes[i] & 0xFF) % DEFAULT_CODEC.length];
            ++i;
        }
        return new String(chars);
    }

    public Random getRandom() {
        return this.random;
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    public int getVerifierLengthBytes() {
        return this.verifierLengthBytes;
    }

    public void setVerifierLengthBytes(int verifierLengthBytes) {
        this.verifierLengthBytes = verifierLengthBytes;
    }
}

