/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.config.annotation.authentication.configurers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.oauth2.provider.BaseClientDetails;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.InMemoryClientDetailsService;
import org.springframework.security.oauth2.provider.client.ClientDetailsUserDetailsService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryClientDetailsServiceConfigurer
extends SecurityConfigurerAdapter<AuthenticationManager, AuthenticationManagerBuilder> {
    private List<ClientBuilder> clientBuilders = new ArrayList<ClientBuilder>();

    public ClientBuilder withClient(String clientId) {
        ClientBuilder clientBuilder = new ClientBuilder(clientId);
        this.clientBuilders.add(clientBuilder);
        return clientBuilder;
    }

    public void init(AuthenticationManagerBuilder builder) throws Exception {
        HashMap<String, ClientDetails> clientDetails = new HashMap<String, ClientDetails>(this.clientBuilders.size());
        for (ClientBuilder clientDetailsBldr : this.clientBuilders) {
            clientDetails.put(clientDetailsBldr.clientId, clientDetailsBldr.build());
        }
        InMemoryClientDetailsService clientDetailsService = new InMemoryClientDetailsService();
        clientDetailsService.setClientDetailsStore(clientDetails);
        ClientDetailsUserDetailsService userDetailsService = new ClientDetailsUserDetailsService((ClientDetailsService)clientDetailsService);
        builder.userDetailsService((UserDetailsService)userDetailsService);
        builder.setSharedObject(ClientDetailsService.class, (Object)clientDetailsService);
    }

    public void configure(AuthenticationManagerBuilder builder) throws Exception {
    }

    public final class ClientBuilder {
        private final String clientId;
        private Collection<String> authorizedGrantTypes = new ArrayList<String>();
        private Collection<String> authorities = new ArrayList<String>();
        private Integer accessTokenValiditySeconds;
        private Integer refreshTokenValiditySeconds;
        private Collection<String> scopes = new ArrayList<String>();
        private String secret;
        private Set<String> registeredRedirectUris = new HashSet<String>();
        private Set<String> resourceIds = new HashSet<String>();

        private ClientDetails build() {
            BaseClientDetails result = new BaseClientDetails();
            result.setClientId(this.clientId);
            result.setAuthorizedGrantTypes(this.authorizedGrantTypes);
            result.setAccessTokenValiditySeconds(this.accessTokenValiditySeconds);
            result.setRefreshTokenValiditySeconds(this.refreshTokenValiditySeconds);
            result.setRegisteredRedirectUri(this.registeredRedirectUris);
            result.setClientSecret(this.secret);
            return result;
        }

        public ClientBuilder resourceIds(String ... resourceIds) {
            for (String resourceId : resourceIds) {
                this.resourceIds.add(resourceId);
            }
            return this;
        }

        public ClientBuilder redirectUris(String ... registeredRedirectUris) {
            for (String redirectUri : registeredRedirectUris) {
                this.registeredRedirectUris.add(redirectUri);
            }
            return this;
        }

        public ClientBuilder authorizedGrantTypes(String ... authorizedGrantTypes) {
            for (String grant : authorizedGrantTypes) {
                this.authorizedGrantTypes.add(grant);
            }
            return this;
        }

        public ClientBuilder accessTokenValiditySeconds(int accessTokenValiditySeconds) {
            this.accessTokenValiditySeconds = accessTokenValiditySeconds;
            return this;
        }

        public ClientBuilder refreshTokenValiditySeconds(int refreshTokenValiditySeconds) {
            this.refreshTokenValiditySeconds = refreshTokenValiditySeconds;
            return this;
        }

        public ClientBuilder secret(String secret) {
            this.secret = secret;
            return this;
        }

        public ClientBuilder scopes(String ... scopes) {
            for (String scope : scopes) {
                this.scopes.add(scope);
            }
            return this;
        }

        public ClientBuilder authorities(String ... authorities) {
            for (String authority : authorities) {
                this.authorities.add(authority);
            }
            return this;
        }

        public InMemoryClientDetailsServiceConfigurer and() {
            return InMemoryClientDetailsServiceConfigurer.this;
        }

        private ClientBuilder(String clientId) {
            this.clientId = clientId;
        }
    }
}

