/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.config.annotation.web.configuration;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configurers.OAuth2ServerConfigurer;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.TokenGranter;
import org.springframework.security.oauth2.provider.code.AuthorizationCodeServices;
import org.springframework.security.oauth2.provider.code.AuthorizationCodeTokenGranter;
import org.springframework.security.oauth2.provider.endpoint.AuthorizationEndpoint;
import org.springframework.security.oauth2.provider.endpoint.FrameworkEndpointHandlerMapping;
import org.springframework.security.oauth2.provider.endpoint.TokenEndpoint;
import org.springframework.security.oauth2.provider.endpoint.WhitelabelApprovalEndpoint;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;
import org.springframework.security.oauth2.provider.token.ConsumerTokenServices;

@Configuration
public abstract class OAuth2ServerConfigurerAdapter
extends WebSecurityConfigurerAdapter {
    @Bean
    public AuthorizationEndpoint authorizationEndpoint() throws Exception {
        AuthorizationEndpoint authorizationEndpoint = new AuthorizationEndpoint();
        authorizationEndpoint.setTokenGranter(this.tokenGranter());
        authorizationEndpoint.setClientDetailsService(this.clientDetails());
        authorizationEndpoint.setAuthorizationCodeServices(this.authorizationCodeServices());
        return authorizationEndpoint;
    }

    @Bean
    public ConsumerTokenServices consumerTokenServices() throws Exception {
        return this.oauthConfigurer().getConsumerTokenServices();
    }

    private AuthorizationCodeServices authorizationCodeServices() throws Exception {
        return this.oauthConfigurer().getAuthorizationCodeServices();
    }

    private TokenGranter tokenGranter() throws Exception {
        return this.oauthConfigurer().getTokenGranter();
    }

    private OAuth2ServerConfigurer oauthConfigurer() throws Exception {
        return (OAuth2ServerConfigurer)this.getHttp().getConfigurer(OAuth2ServerConfigurer.class);
    }

    @Bean
    public TokenEndpoint tokenEndpoint() throws Exception {
        TokenEndpoint tokenEndpoint = new TokenEndpoint();
        tokenEndpoint.setClientDetailsService(this.clientDetails());
        tokenEndpoint.setTokenGranter(this.tokenGranter());
        return tokenEndpoint;
    }

    @Bean
    public AuthorizationCodeTokenGranter authorizationTokenGranter() throws Exception {
        return new AuthorizationCodeTokenGranter(this.tokenServices(), this.authorizationCodeServices(), this.clientDetails());
    }

    protected AuthorizationServerTokenServices tokenServices() throws Exception {
        return this.oauthConfigurer().getTokenServices();
    }

    @Bean
    public WhitelabelApprovalEndpoint approvalEndpoint() {
        return new WhitelabelApprovalEndpoint();
    }

    @Bean
    public FrameworkEndpointHandlerMapping endpointHandlerMapping() {
        return new FrameworkEndpointHandlerMapping();
    }

    @Bean
    public ClientDetailsService clientDetailsServiceBean() throws Exception {
        return this.clientDetails();
    }

    private ClientDetailsService clientDetails() throws Exception {
        return (ClientDetailsService)this.getHttp().getSharedObject(ClientDetailsService.class);
    }
}

