/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.config.annotation.web.configurers;

import java.util.ArrayList;
import javax.servlet.Filter;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExceptionHandlingConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.HttpBasicConfigurer;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.CompositeTokenGranter;
import org.springframework.security.oauth2.provider.TokenGranter;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationManager;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationProcessingFilter;
import org.springframework.security.oauth2.provider.client.ClientCredentialsTokenEndpointFilter;
import org.springframework.security.oauth2.provider.client.ClientCredentialsTokenGranter;
import org.springframework.security.oauth2.provider.code.AuthorizationCodeServices;
import org.springframework.security.oauth2.provider.code.AuthorizationCodeTokenGranter;
import org.springframework.security.oauth2.provider.code.InMemoryAuthorizationCodeServices;
import org.springframework.security.oauth2.provider.error.OAuth2AccessDeniedHandler;
import org.springframework.security.oauth2.provider.error.OAuth2AuthenticationEntryPoint;
import org.springframework.security.oauth2.provider.expression.OAuth2WebSecurityExpressionHandler;
import org.springframework.security.oauth2.provider.implicit.ImplicitTokenGranter;
import org.springframework.security.oauth2.provider.password.ResourceOwnerPasswordTokenGranter;
import org.springframework.security.oauth2.provider.refresh.RefreshTokenGranter;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;
import org.springframework.security.oauth2.provider.token.ConsumerTokenServices;
import org.springframework.security.oauth2.provider.token.DefaultTokenServices;
import org.springframework.security.oauth2.provider.token.InMemoryTokenStore;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OAuth2ServerConfigurer
extends SecurityConfigurerAdapter<DefaultSecurityFilterChain, HttpSecurity> {
    private AuthenticationEntryPoint authenticationEntryPoint = new OAuth2AuthenticationEntryPoint();
    private AccessDeniedHandler accessDeniedHandler = new OAuth2AccessDeniedHandler();
    private ClientCredentialsTokenEndpointFilter clientCredentialsTokenEndpointFilter;
    private OAuth2AuthenticationProcessingFilter resourcesServerFilter;
    private AuthorizationServerTokenServices tokenServices;
    private AuthorizationCodeServices authorizationCodeServices;
    private ResourceServerTokenServices resourceTokenServices;
    private TokenStore tokenStore;
    private TokenGranter tokenGranter;
    private ConsumerTokenServices consumerTokenServices;
    private String resourceId = "oauth2-resource";
    private SecurityExpressionHandler<FilterInvocation> expressionHandler = new OAuth2WebSecurityExpressionHandler();

    private ClientDetailsService clientDetails() {
        return (ClientDetailsService)((HttpSecurity)this.getBuilder()).getSharedObject(ClientDetailsService.class);
    }

    public AuthorizationServerTokenServices getTokenServices() {
        return this.tokenServices;
    }

    public void init(HttpSecurity http) throws Exception {
        if (http.getConfigurer(HttpBasicConfigurer.class) == null) {
            http.httpBasic();
        }
        http.setSharedObject(AuthenticationEntryPoint.class, (Object)this.authenticationEntryPoint);
    }

    public OAuth2ServerConfigurer resourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public void configure(HttpSecurity http) throws Exception {
        ((ExpressionUrlAuthorizationConfigurer)http.getConfigurer(ExpressionUrlAuthorizationConfigurer.class)).expressionHandler(this.expressionHandler);
        this.clientCredentialsTokenEndpointFilter = new ClientCredentialsTokenEndpointFilter();
        this.clientCredentialsTokenEndpointFilter.setAuthenticationManager(http.getAuthenticationManager());
        this.clientCredentialsTokenEndpointFilter = (ClientCredentialsTokenEndpointFilter)this.postProcess(this.clientCredentialsTokenEndpointFilter);
        AuthenticationManager oauthAuthenticationManager = this.oauthAuthenticationManager(http);
        this.resourcesServerFilter = new OAuth2AuthenticationProcessingFilter();
        this.resourcesServerFilter.setAuthenticationManager(oauthAuthenticationManager);
        this.resourcesServerFilter = (OAuth2AuthenticationProcessingFilter)this.postProcess(this.resourcesServerFilter);
        this.tokenGranter = this.tokenGranter(http);
        this.consumerTokenServices = this.consumerTokenServices(http);
        ((ExceptionHandlingConfigurer)http.getConfigurer(ExceptionHandlingConfigurer.class)).accessDeniedHandler(this.accessDeniedHandler);
        http.addFilterBefore((Filter)this.resourcesServerFilter, AbstractPreAuthenticatedProcessingFilter.class).addFilterBefore((Filter)this.clientCredentialsTokenEndpointFilter, BasicAuthenticationFilter.class);
    }

    private AuthenticationManager oauthAuthenticationManager(HttpSecurity http) {
        OAuth2AuthenticationManager oauthAuthenticationManager = new OAuth2AuthenticationManager();
        oauthAuthenticationManager.setResourceId(this.resourceId);
        oauthAuthenticationManager.setTokenServices(this.resourceTokenServices(http));
        return oauthAuthenticationManager;
    }

    private ResourceServerTokenServices resourceTokenServices(HttpSecurity http) {
        this.tokenServices(http);
        return this.resourceTokenServices;
    }

    private AuthorizationServerTokenServices tokenServices(HttpSecurity http) {
        if (this.tokenServices != null) {
            return this.tokenServices;
        }
        DefaultTokenServices tokenServices = new DefaultTokenServices();
        tokenServices.setTokenStore(this.tokenStore());
        tokenServices.setSupportRefreshToken(true);
        tokenServices.setClientDetailsService(this.clientDetails());
        this.tokenServices = tokenServices;
        this.resourceTokenServices = tokenServices;
        return tokenServices;
    }

    private TokenStore tokenStore() {
        if (this.tokenStore == null) {
            this.tokenStore = new InMemoryTokenStore();
        }
        return this.tokenStore;
    }

    public AuthorizationCodeServices getAuthorizationCodeServices() {
        return this.authorizationCodeServices;
    }

    private AuthorizationCodeServices authorizationCodeServices(HttpSecurity http) {
        if (this.authorizationCodeServices == null) {
            this.authorizationCodeServices = new InMemoryAuthorizationCodeServices();
        }
        return this.authorizationCodeServices;
    }

    private AuthenticationManager authenticationManager(HttpSecurity http) {
        return http.getAuthenticationManager();
    }

    public TokenGranter getTokenGranter() {
        return this.tokenGranter;
    }

    public ConsumerTokenServices getConsumerTokenServices() {
        return this.consumerTokenServices;
    }

    private ConsumerTokenServices consumerTokenServices(HttpSecurity http) {
        if (this.consumerTokenServices == null) {
            DefaultTokenServices defaultTokenServices = new DefaultTokenServices();
            defaultTokenServices.setClientDetailsService(this.clientDetails());
            defaultTokenServices.setTokenStore(this.tokenStore());
            this.consumerTokenServices = defaultTokenServices;
        }
        return this.consumerTokenServices;
    }

    private TokenGranter tokenGranter(HttpSecurity http) throws Exception {
        if (this.tokenGranter == null) {
            ClientDetailsService clientDetails = this.clientDetails();
            AuthorizationServerTokenServices tokenServices = this.tokenServices(http);
            AuthorizationCodeServices authorizationCodeServices = this.authorizationCodeServices(http);
            AuthenticationManager authenticationManager = this.authenticationManager(http);
            ArrayList<Object> tokenGranters = new ArrayList<Object>();
            tokenGranters.add(new AuthorizationCodeTokenGranter(tokenServices, authorizationCodeServices, clientDetails));
            tokenGranters.add(new RefreshTokenGranter(tokenServices, clientDetails));
            tokenGranters.add(new ImplicitTokenGranter(tokenServices, clientDetails));
            tokenGranters.add(new ClientCredentialsTokenGranter(tokenServices, clientDetails));
            tokenGranters.add(new ResourceOwnerPasswordTokenGranter(authenticationManager, tokenServices, clientDetails));
            this.tokenGranter = new CompositeTokenGranter(tokenGranters);
        }
        return this.tokenGranter;
    }
}

