/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.filter;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.oauth2.client.UserRedirectRequiredException;
import org.springframework.security.oauth2.client.http.AccessTokenRequiredException;
import org.springframework.security.oauth2.client.resource.OAuth2AccessDeniedException;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.common.DefaultThrowableAnalyzer;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.PortResolver;
import org.springframework.security.web.PortResolverImpl;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.util.ThrowableAnalyzer;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.util.Assert;
import org.springframework.web.util.NestedServletException;

public class OAuth2ClientContextFilter
implements Filter,
InitializingBean {
    public static final String CURRENT_URI = "currentUri";
    private PortResolver portResolver = new PortResolverImpl();
    private ThrowableAnalyzer throwableAnalyzer = new DefaultThrowableAnalyzer();
    private RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.redirectStrategy, (String)"A redirect strategy must be supplied.");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        request.setAttribute(CURRENT_URI, (Object)this.calculateCurrentUri(request));
        try {
            chain.doFilter(servletRequest, servletResponse);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            Throwable[] causeChain = this.throwableAnalyzer.determineCauseChain((Throwable)ex);
            UserRedirectRequiredException redirect = (UserRedirectRequiredException)this.throwableAnalyzer.getFirstThrowableOfType(UserRedirectRequiredException.class, causeChain);
            if (redirect != null) {
                this.redirectUser(redirect, request, response);
            }
            if (ex instanceof ServletException) {
                throw (ServletException)ex;
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new NestedServletException("Unhandled exception", (Throwable)ex);
        }
    }

    protected void redirectUser(UserRedirectRequiredException e, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String redirectUri = e.getRedirectUri();
        StringBuilder builder = new StringBuilder(redirectUri);
        Map<String, String> requestParams = e.getRequestParams();
        int appendChar = redirectUri.indexOf(63) < 0 ? 63 : 38;
        for (Map.Entry<String, String> param : requestParams.entrySet()) {
            try {
                builder.append((char)appendChar).append(param.getKey()).append('=').append(URLEncoder.encode(param.getValue(), "UTF-8"));
            }
            catch (UnsupportedEncodingException uee) {
                throw new IllegalStateException(uee);
            }
            appendChar = 38;
        }
        if (e.getStateKey() != null) {
            builder.append((char)appendChar).append("state").append('=').append(e.getStateKey());
        }
        this.redirectStrategy.sendRedirect(request, response, builder.toString());
    }

    protected OAuth2ProtectedResourceDetails checkForResourceThatNeedsAuthorization(Exception ex) throws ServletException, IOException {
        OAuth2ProtectedResourceDetails resourceThatNeedsAuthorization;
        Throwable[] causeChain = this.throwableAnalyzer.determineCauseChain((Throwable)ex);
        AccessTokenRequiredException ase = (AccessTokenRequiredException)((Object)this.throwableAnalyzer.getFirstThrowableOfType(AccessTokenRequiredException.class, causeChain));
        if (ase != null) {
            resourceThatNeedsAuthorization = ase.getResource();
            if (resourceThatNeedsAuthorization == null) {
                throw new OAuth2AccessDeniedException(ase.getMessage());
            }
        } else {
            if (ex instanceof ServletException) {
                throw (ServletException)ex;
            }
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
        return resourceThatNeedsAuthorization;
    }

    protected String calculateCurrentUri(HttpServletRequest request) throws UnsupportedEncodingException {
        StringBuilder queryBuilder = new StringBuilder();
        Enumeration paramNames = request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String name = (String)paramNames.nextElement();
            if (!"code".equals(name)) {
                String[] parameterValues = request.getParameterValues(name);
                if (parameterValues.length == 0) {
                    queryBuilder.append(URLEncoder.encode(name, "UTF-8"));
                } else {
                    for (int i = 0; i < parameterValues.length; ++i) {
                        String parameterValue = parameterValues[i];
                        queryBuilder.append(URLEncoder.encode(name, "UTF-8")).append('=').append(URLEncoder.encode(parameterValue, "UTF-8"));
                        if (i + 1 >= parameterValues.length) continue;
                        queryBuilder.append('&');
                    }
                }
            }
            if (!paramNames.hasMoreElements() || queryBuilder.length() <= 0) continue;
            queryBuilder.append('&');
        }
        return UrlUtils.buildFullRequestUrl((String)request.getScheme(), (String)request.getServerName(), (int)this.portResolver.getServerPort((ServletRequest)request), (String)request.getRequestURI(), (String)(queryBuilder.length() > 0 ? queryBuilder.toString() : null));
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void setThrowableAnalyzer(ThrowableAnalyzer throwableAnalyzer) {
        this.throwableAnalyzer = throwableAnalyzer;
    }

    public void setPortResolver(PortResolver portResolver) {
        this.portResolver = portResolver;
    }

    public void setRedirectStrategy(RedirectStrategy redirectStrategy) {
        this.redirectStrategy = redirectStrategy;
    }
}

