/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.springframework.security.oauth2.common.exceptions.InvalidClientException;
import org.springframework.security.oauth2.common.util.OAuth2Utils;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.AuthorizationRequestFactory;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.DefaultAuthorizationRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAuthorizationRequestFactory
implements AuthorizationRequestFactory {
    private final ClientDetailsService clientDetailsService;

    public DefaultAuthorizationRequestFactory(ClientDetailsService clientDetailsService) {
        this.clientDetailsService = clientDetailsService;
    }

    @Override
    public AuthorizationRequest createAuthorizationRequest(Map<String, String> parameters) {
        String clientId = parameters.get("client_id");
        if (clientId == null) {
            throw new InvalidClientException("A client id must be provided");
        }
        ClientDetails clientDetails = this.clientDetailsService.loadClientByClientId(clientId);
        Set<String> scopes = OAuth2Utils.parseParameterList(parameters.get("scope"));
        if (scopes == null || scopes.isEmpty()) {
            scopes = clientDetails.getScope();
        }
        DefaultAuthorizationRequest request = new DefaultAuthorizationRequest(parameters, Collections.<String, String>emptyMap(), clientId, scopes);
        request.addClientDetails(clientDetails);
        return request;
    }
}

