/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.endpoint;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.oauth2.provider.AuthorizationRequestFactory;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.DefaultAuthorizationRequestFactory;
import org.springframework.security.oauth2.provider.TokenGranter;
import org.springframework.security.oauth2.provider.endpoint.DefaultScopeValidator;
import org.springframework.security.oauth2.provider.endpoint.ParametersValidator;
import org.springframework.security.oauth2.provider.error.DefaultWebResponseExceptionTranslator;
import org.springframework.security.oauth2.provider.error.WebResponseExceptionTranslator;
import org.springframework.util.Assert;

public class AbstractEndpoint
implements InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private WebResponseExceptionTranslator providerExceptionHandler = new DefaultWebResponseExceptionTranslator();
    private TokenGranter tokenGranter;
    private ClientDetailsService clientDetailsService;
    private AuthorizationRequestFactory authorizationRequestFactory;
    private ParametersValidator parametersValidator;
    private AuthorizationRequestFactory defaultAuthorizationRequestFactory;

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.tokenGranter != null ? 1 : 0) != 0, (String)"TokenGranter must be provided");
        Assert.state((this.clientDetailsService != null ? 1 : 0) != 0, (String)"ClientDetailsService must be provided");
        this.defaultAuthorizationRequestFactory = new DefaultAuthorizationRequestFactory(this.getClientDetailsService());
        if (this.authorizationRequestFactory == null) {
            this.authorizationRequestFactory = this.defaultAuthorizationRequestFactory;
        }
        if (this.getParametersValidator() == null) {
            this.setParametersValidator(new DefaultScopeValidator());
        }
    }

    public void setProviderExceptionHandler(WebResponseExceptionTranslator providerExceptionHandler) {
        this.providerExceptionHandler = providerExceptionHandler;
    }

    public void setTokenGranter(TokenGranter tokenGranter) {
        this.tokenGranter = tokenGranter;
    }

    protected TokenGranter getTokenGranter() {
        return this.tokenGranter;
    }

    protected WebResponseExceptionTranslator getExceptionTranslator() {
        return this.providerExceptionHandler;
    }

    protected AuthorizationRequestFactory getAuthorizationRequestFactory() {
        return this.authorizationRequestFactory;
    }

    protected AuthorizationRequestFactory getDefaultAuthorizationRequestFactory() {
        return this.defaultAuthorizationRequestFactory;
    }

    public void setAuthorizationRequestFactory(AuthorizationRequestFactory authorizationRequestFactory) {
        this.authorizationRequestFactory = authorizationRequestFactory;
    }

    public void setParametersValidator(ParametersValidator parametersValidator) {
        this.parametersValidator = parametersValidator;
    }

    protected ClientDetailsService getClientDetailsService() {
        return this.clientDetailsService;
    }

    public void setClientDetailsService(ClientDetailsService clientDetailsService) {
        this.clientDetailsService = clientDetailsService;
    }

    protected ParametersValidator getParametersValidator() {
        return this.parametersValidator;
    }
}

