/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.endpoint;

import java.util.Map;
import java.util.Set;
import org.springframework.security.oauth2.common.exceptions.InvalidScopeException;
import org.springframework.security.oauth2.common.util.OAuth2Utils;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.endpoint.ParametersValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultScopeValidator
implements ParametersValidator {
    @Override
    public void validateParameters(Map<String, String> parameters, ClientDetails clientDetails) {
        if (parameters.containsKey("scope") && clientDetails.isScoped()) {
            Set<String> validScope = clientDetails.getScope();
            for (String scope : OAuth2Utils.parseParameterList(parameters.get("scope"))) {
                if (validScope.contains(scope)) continue;
                throw new InvalidScopeException("Invalid scope: " + scope, validScope);
            }
        }
    }
}

