/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.endpoint;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.springframework.util.AntPathMatcher;

public class EndpointValidationFilter
implements Filter {
    private static final String DEFAULT_AUTHORIZATION_ENDPOINT_URL = "/oauth/authorize";
    private static final String DEFAULT_TOKEN_ENDPOINT_URL = "/oauth/token";
    private String authorizationEndpointUrl = "/oauth/authorize";
    private String tokenEndpointUrl = "/oauth/token";
    private AntPathMatcher matcher = new AntPathMatcher();

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        if (this.matches(servletRequest, this.authorizationEndpointUrl)) {
            servletRequest = this.wrapRequest(servletRequest, DEFAULT_AUTHORIZATION_ENDPOINT_URL);
        } else if (this.matches(servletRequest, this.tokenEndpointUrl)) {
            servletRequest = this.wrapRequest(servletRequest, DEFAULT_TOKEN_ENDPOINT_URL);
        }
        chain.doFilter((ServletRequest)servletRequest, response);
    }

    private HttpServletRequest wrapRequest(final HttpServletRequest request, final String urlToMatch) {
        if (this.matches(request, urlToMatch)) {
            return request;
        }
        return new HttpServletRequestWrapper(request){
            private String requestUri;
            private String originalRequestUri;
            private String originalServletPath;
            {
                super(x0);
                this.requestUri = EndpointValidationFilter.this.prependContextPath(request, urlToMatch);
                this.originalRequestUri = request.getRequestURI();
                this.originalServletPath = request.getServletPath();
            }

            public String getRequestURI() {
                String standard = super.getRequestURI();
                if (standard.equals(this.originalRequestUri)) {
                    return this.requestUri;
                }
                return standard;
            }

            public String getServletPath() {
                String standard = super.getServletPath();
                if (standard.equals(this.originalServletPath)) {
                    return urlToMatch;
                }
                return super.getServletPath();
            }
        };
    }

    public void init(FilterConfig config) throws ServletException {
    }

    protected boolean matches(HttpServletRequest request, String urlToMatch) {
        String uri = this.extractUri(request);
        String contextPath = this.prependContextPath(request, urlToMatch);
        return this.matcher.match(contextPath, uri);
    }

    private String prependContextPath(HttpServletRequest request, String urlToMatch) {
        if ("".equals(request.getContextPath())) {
            return urlToMatch;
        }
        return request.getContextPath() + urlToMatch;
    }

    private String extractUri(HttpServletRequest request) {
        String uri = request.getRequestURI();
        int pathParamIndex = uri.indexOf(59);
        if (pathParamIndex > 0) {
            uri = uri.substring(0, pathParamIndex);
        }
        return uri;
    }

    public void setAuthorizationEndpointUrl(String authorizationEndpointUrl) {
        this.authorizationEndpointUrl = authorizationEndpointUrl;
    }

    public void setTokenEndpointUrl(String tokenEndpointUrl) {
        this.tokenEndpointUrl = tokenEndpointUrl;
    }
}

