/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.refresh;

import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.token.AbstractTokenGranter;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;

public class RefreshTokenGranter
extends AbstractTokenGranter {
    private static final String GRANT_TYPE = "refresh_token";

    public RefreshTokenGranter(AuthorizationServerTokenServices tokenServices, ClientDetailsService clientDetailsService) {
        super(tokenServices, clientDetailsService, GRANT_TYPE);
    }

    protected OAuth2AccessToken getAccessToken(AuthorizationRequest authorizationRequest) {
        String refreshToken = authorizationRequest.getAuthorizationParameters().get(GRANT_TYPE);
        return this.getTokenServices().refreshAccessToken(refreshToken, authorizationRequest.getScope());
    }
}

