/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.token;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2RefreshToken;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.AuthenticationKeyGenerator;
import org.springframework.security.oauth2.provider.token.DefaultAuthenticationKeyGenerator;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryTokenStore
implements TokenStore {
    private static final int DEFAULT_FLUSH_INTERVAL = 1000;
    private final ConcurrentHashMap<String, OAuth2AccessToken> accessTokenStore = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, OAuth2AccessToken> authenticationToAccessTokenStore = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Collection<OAuth2AccessToken>> userNameToAccessTokenStore = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Collection<OAuth2AccessToken>> clientIdToAccessTokenStore = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, OAuth2RefreshToken> refreshTokenStore = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, String> accessTokenToRefreshTokenStore = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, OAuth2Authentication> authenticationStore = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, OAuth2Authentication> refreshTokenAuthenticationStore = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, String> refreshTokenToAcessTokenStore = new ConcurrentHashMap();
    private final DelayQueue<TokenExpiry> expiryQueue = new DelayQueue();
    private final ConcurrentHashMap<String, TokenExpiry> expiryMap = new ConcurrentHashMap();
    private int flushInterval = 1000;
    private AuthenticationKeyGenerator authenticationKeyGenerator = new DefaultAuthenticationKeyGenerator();
    private AtomicInteger flushCounter = new AtomicInteger(0);

    public void setFlushInterval(int flushInterval) {
        this.flushInterval = flushInterval;
    }

    public int getFlushInterval() {
        return this.flushInterval;
    }

    public void clear() {
        this.accessTokenStore.clear();
        this.authenticationToAccessTokenStore.clear();
        this.userNameToAccessTokenStore.clear();
        this.clientIdToAccessTokenStore.clear();
        this.refreshTokenStore.clear();
        this.accessTokenToRefreshTokenStore.clear();
        this.authenticationStore.clear();
        this.refreshTokenAuthenticationStore.clear();
        this.refreshTokenToAcessTokenStore.clear();
        this.expiryQueue.clear();
    }

    public void setAuthenticationKeyGenerator(AuthenticationKeyGenerator authenticationKeyGenerator) {
        this.authenticationKeyGenerator = authenticationKeyGenerator;
    }

    public int getAccessTokenCount() {
        Assert.state((this.accessTokenStore.isEmpty() || this.accessTokenStore.size() >= this.accessTokenToRefreshTokenStore.size() ? 1 : 0) != 0, (String)"Too many refresh tokens");
        Assert.state((this.accessTokenStore.size() == this.authenticationToAccessTokenStore.size() ? 1 : 0) != 0, (String)"Inconsistent token store state");
        Assert.state((this.accessTokenStore.size() <= this.authenticationStore.size() ? 1 : 0) != 0, (String)"Inconsistent authentication store state");
        return this.accessTokenStore.size();
    }

    public int getRefreshTokenCount() {
        Assert.state((this.refreshTokenStore.size() == this.refreshTokenToAcessTokenStore.size() ? 1 : 0) != 0, (String)"Inconsistent refresh token store state");
        return this.accessTokenStore.size();
    }

    public int getExpiryTokenCount() {
        return this.expiryQueue.size();
    }

    @Override
    public OAuth2AccessToken getAccessToken(OAuth2Authentication authentication) {
        OAuth2AccessToken accessToken = this.authenticationToAccessTokenStore.get(this.authenticationKeyGenerator.extractKey(authentication));
        if (accessToken != null && !authentication.equals((Object)this.readAuthentication(accessToken.getValue()))) {
            this.storeAccessToken(accessToken, authentication);
        }
        return accessToken;
    }

    @Override
    public OAuth2Authentication readAuthentication(OAuth2AccessToken token) {
        return this.readAuthentication(token.getValue());
    }

    @Override
    public OAuth2Authentication readAuthentication(String token) {
        return this.authenticationStore.get(token);
    }

    @Override
    public OAuth2Authentication readAuthenticationForRefreshToken(OAuth2RefreshToken token) {
        return this.readAuthenticationForRefreshToken(token.getValue());
    }

    public OAuth2Authentication readAuthenticationForRefreshToken(String token) {
        return this.refreshTokenAuthenticationStore.get(token);
    }

    @Override
    public void storeAccessToken(OAuth2AccessToken token, OAuth2Authentication authentication) {
        if (this.flushCounter.incrementAndGet() >= this.flushInterval) {
            this.flush();
            this.flushCounter.set(0);
        }
        this.accessTokenStore.put(token.getValue(), token);
        this.authenticationStore.put(token.getValue(), authentication);
        this.authenticationToAccessTokenStore.put(this.authenticationKeyGenerator.extractKey(authentication), token);
        if (!authentication.isClientOnly()) {
            this.addToCollection(this.userNameToAccessTokenStore, authentication.getName(), token);
        }
        this.addToCollection(this.clientIdToAccessTokenStore, authentication.getAuthorizationRequest().getClientId(), token);
        if (token.getExpiration() != null) {
            TokenExpiry expiry = new TokenExpiry(token.getValue(), token.getExpiration());
            this.expiryQueue.remove(this.expiryMap.put(token.getValue(), expiry));
            this.expiryQueue.put(expiry);
        }
        if (token.getRefreshToken() != null && token.getRefreshToken().getValue() != null) {
            this.refreshTokenToAcessTokenStore.put(token.getRefreshToken().getValue(), token.getValue());
            this.accessTokenToRefreshTokenStore.put(token.getValue(), token.getRefreshToken().getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToCollection(ConcurrentHashMap<String, Collection<OAuth2AccessToken>> store, String key, OAuth2AccessToken token) {
        if (!store.containsKey(key)) {
            ConcurrentHashMap<String, Collection<OAuth2AccessToken>> concurrentHashMap = store;
            synchronized (concurrentHashMap) {
                if (!store.containsKey(key)) {
                    store.put(key, new HashSet());
                }
            }
        }
        store.get(key).add(token);
    }

    @Override
    public void removeAccessToken(OAuth2AccessToken accessToken) {
        this.removeAccessToken(accessToken.getValue());
    }

    @Override
    public OAuth2AccessToken readAccessToken(String tokenValue) {
        return this.accessTokenStore.get(tokenValue);
    }

    public void removeAccessToken(String tokenValue) {
        OAuth2Authentication authentication;
        OAuth2AccessToken removed = this.accessTokenStore.remove(tokenValue);
        String refresh = this.accessTokenToRefreshTokenStore.remove(tokenValue);
        if (refresh != null) {
            this.refreshTokenToAcessTokenStore.remove(tokenValue);
        }
        if ((authentication = this.authenticationStore.remove(tokenValue)) != null) {
            this.authenticationToAccessTokenStore.remove(this.authenticationKeyGenerator.extractKey(authentication));
            Collection<OAuth2AccessToken> tokens = this.userNameToAccessTokenStore.get(authentication.getName());
            if (tokens != null) {
                tokens.remove(removed);
            }
            if ((tokens = this.clientIdToAccessTokenStore.get(authentication.getName())) != null) {
                tokens.remove(removed);
            }
            this.authenticationToAccessTokenStore.remove(this.authenticationKeyGenerator.extractKey(authentication));
        }
    }

    @Override
    public void storeRefreshToken(OAuth2RefreshToken refreshToken, OAuth2Authentication authentication) {
        this.refreshTokenStore.put(refreshToken.getValue(), refreshToken);
        this.refreshTokenAuthenticationStore.put(refreshToken.getValue(), authentication);
    }

    @Override
    public OAuth2RefreshToken readRefreshToken(String tokenValue) {
        return this.refreshTokenStore.get(tokenValue);
    }

    @Override
    public void removeRefreshToken(OAuth2RefreshToken refreshToken) {
        this.removeRefreshToken(refreshToken.getValue());
    }

    public void removeRefreshToken(String tokenValue) {
        this.refreshTokenStore.remove(tokenValue);
        this.refreshTokenAuthenticationStore.remove(tokenValue);
        this.refreshTokenToAcessTokenStore.remove(tokenValue);
    }

    @Override
    public void removeAccessTokenUsingRefreshToken(OAuth2RefreshToken refreshToken) {
        this.removeAccessTokenUsingRefreshToken(refreshToken.getValue());
    }

    private void removeAccessTokenUsingRefreshToken(String refreshToken) {
        String accessToken = this.refreshTokenToAcessTokenStore.remove(refreshToken);
        if (accessToken != null) {
            this.removeAccessToken(accessToken);
        }
    }

    @Override
    public Collection<OAuth2AccessToken> findTokensByClientId(String clientId) {
        Collection<OAuth2AccessToken> result = this.clientIdToAccessTokenStore.get(clientId);
        return result != null ? Collections.unmodifiableCollection(result) : Collections.emptySet();
    }

    @Override
    public Collection<OAuth2AccessToken> findTokensByUserName(String userName) {
        Collection<OAuth2AccessToken> result = this.userNameToAccessTokenStore.get(userName);
        return result != null ? Collections.unmodifiableCollection(result) : Collections.emptySet();
    }

    private void flush() {
        TokenExpiry expiry = (TokenExpiry)this.expiryQueue.poll();
        while (expiry != null) {
            this.removeAccessToken(expiry.getValue());
            expiry = (TokenExpiry)this.expiryQueue.poll();
        }
    }

    private static class TokenExpiry
    implements Delayed {
        private final long expiry;
        private final String value;

        public TokenExpiry(String value, Date date) {
            this.value = value;
            this.expiry = date.getTime();
        }

        public int compareTo(Delayed other) {
            if (this == other) {
                return 0;
            }
            long diff = this.getDelay(TimeUnit.MILLISECONDS) - other.getDelay(TimeUnit.MILLISECONDS);
            return diff == 0L ? 0 : (diff < 0L ? -1 : 1);
        }

        public long getDelay(TimeUnit unit) {
            return this.expiry - System.currentTimeMillis();
        }

        public String getValue() {
            return this.value;
        }
    }
}

