/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.token;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.support.SqlLobValue;
import org.springframework.security.oauth2.common.DefaultOAuth2RefreshToken;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2RefreshToken;
import org.springframework.security.oauth2.common.util.SerializationUtils;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.AuthenticationKeyGenerator;
import org.springframework.security.oauth2.provider.token.DefaultAuthenticationKeyGenerator;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcTokenStore
implements TokenStore {
    private static final Log LOG = LogFactory.getLog(JdbcTokenStore.class);
    private static final String DEFAULT_ACCESS_TOKEN_INSERT_STATEMENT = "insert into oauth_access_token (token_id, token, authentication_id, user_name, client_id, authentication, refresh_token) values (?, ?, ?, ?, ?, ?, ?)";
    private static final String DEFAULT_ACCESS_TOKEN_SELECT_STATEMENT = "select token_id, token from oauth_access_token where token_id = ?";
    private static final String DEFAULT_ACCESS_TOKEN_AUTHENTICATION_SELECT_STATEMENT = "select token_id, authentication from oauth_access_token where token_id = ?";
    private static final String DEFAULT_ACCESS_TOKEN_FROM_AUTHENTICATION_SELECT_STATEMENT = "select token_id, token from oauth_access_token where authentication_id = ?";
    private static final String DEFAULT_ACCESS_TOKENS_FROM_USERNAME_SELECT_STATEMENT = "select token_id, token from oauth_access_token where user_name = ?";
    private static final String DEFAULT_ACCESS_TOKENS_FROM_CLIENTID_SELECT_STATEMENT = "select token_id, token from oauth_access_token where client_id = ?";
    private static final String DEFAULT_ACCESS_TOKEN_DELETE_STATEMENT = "delete from oauth_access_token where token_id = ?";
    private static final String DEFAULT_ACCESS_TOKEN_DELETE_FROM_REFRESH_TOKEN_STATEMENT = "delete from oauth_access_token where refresh_token = ?";
    private static final String DEFAULT_REFRESH_TOKEN_INSERT_STATEMENT = "insert into oauth_refresh_token (token_id, token, authentication) values (?, ?, ?)";
    private static final String DEFAULT_REFRESH_TOKEN_SELECT_STATEMENT = "select token_id, token from oauth_refresh_token where token_id = ?";
    private static final String DEFAULT_REFRESH_TOKEN_AUTHENTICATION_SELECT_STATEMENT = "select token_id, authentication from oauth_refresh_token where token_id = ?";
    private static final String DEFAULT_REFRESH_TOKEN_DELETE_STATEMENT = "delete from oauth_refresh_token where token_id = ?";
    private String insertAccessTokenSql = "insert into oauth_access_token (token_id, token, authentication_id, user_name, client_id, authentication, refresh_token) values (?, ?, ?, ?, ?, ?, ?)";
    private String selectAccessTokenSql = "select token_id, token from oauth_access_token where token_id = ?";
    private String selectAccessTokenAuthenticationSql = "select token_id, authentication from oauth_access_token where token_id = ?";
    private String selectAccessTokenFromAuthenticationSql = "select token_id, token from oauth_access_token where authentication_id = ?";
    private String selectAccessTokensFromUserNameSql = "select token_id, token from oauth_access_token where user_name = ?";
    private String selectAccessTokensFromClientIdSql = "select token_id, token from oauth_access_token where client_id = ?";
    private String deleteAccessTokenSql = "delete from oauth_access_token where token_id = ?";
    private String insertRefreshTokenSql = "insert into oauth_refresh_token (token_id, token, authentication) values (?, ?, ?)";
    private String selectRefreshTokenSql = "select token_id, token from oauth_refresh_token where token_id = ?";
    private String selectRefreshTokenAuthenticationSql = "select token_id, authentication from oauth_refresh_token where token_id = ?";
    private String deleteRefreshTokenSql = "delete from oauth_refresh_token where token_id = ?";
    private String deleteAccessTokenFromRefreshTokenSql = "delete from oauth_access_token where refresh_token = ?";
    private AuthenticationKeyGenerator authenticationKeyGenerator = new DefaultAuthenticationKeyGenerator();
    private final JdbcTemplate jdbcTemplate;

    public JdbcTokenStore(DataSource dataSource) {
        Assert.notNull((Object)dataSource, (String)"DataSource required");
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public void setAuthenticationKeyGenerator(AuthenticationKeyGenerator authenticationKeyGenerator) {
        this.authenticationKeyGenerator = authenticationKeyGenerator;
    }

    @Override
    public OAuth2AccessToken getAccessToken(OAuth2Authentication authentication) {
        OAuth2AccessToken accessToken;
        block3: {
            accessToken = null;
            try {
                accessToken = (OAuth2AccessToken)this.jdbcTemplate.queryForObject(this.selectAccessTokenFromAuthenticationSql, (RowMapper)new RowMapper<OAuth2AccessToken>(){

                    public OAuth2AccessToken mapRow(ResultSet rs, int rowNum) throws SQLException {
                        return (OAuth2AccessToken)SerializationUtils.deserialize(rs.getBytes(2));
                    }
                }, new Object[]{this.authenticationKeyGenerator.extractKey(authentication)});
            }
            catch (EmptyResultDataAccessException e) {
                if (!LOG.isInfoEnabled()) break block3;
                LOG.debug((Object)("Failed to find access token for authentication " + (Object)((Object)authentication)));
            }
        }
        if (accessToken != null && !authentication.equals((Object)this.readAuthentication(accessToken.getValue()))) {
            this.removeAccessToken(accessToken.getValue());
            this.storeAccessToken(accessToken, authentication);
        }
        return accessToken;
    }

    @Override
    public void storeAccessToken(OAuth2AccessToken token, OAuth2Authentication authentication) {
        String refreshToken = null;
        if (token.getRefreshToken() != null) {
            refreshToken = token.getRefreshToken().getValue();
        }
        this.jdbcTemplate.update(this.insertAccessTokenSql, new Object[]{token.getValue(), new SqlLobValue(SerializationUtils.serialize(token)), this.authenticationKeyGenerator.extractKey(authentication), authentication.isClientOnly() ? null : authentication.getName(), authentication.getAuthorizationRequest().getClientId(), new SqlLobValue(SerializationUtils.serialize((Object)authentication)), refreshToken}, new int[]{12, 2004, 12, 12, 12, 2004, 12});
    }

    @Override
    public OAuth2AccessToken readAccessToken(String tokenValue) {
        OAuth2AccessToken accessToken;
        block2: {
            accessToken = null;
            try {
                accessToken = (OAuth2AccessToken)this.jdbcTemplate.queryForObject(this.selectAccessTokenSql, (RowMapper)new RowMapper<OAuth2AccessToken>(){

                    public OAuth2AccessToken mapRow(ResultSet rs, int rowNum) throws SQLException {
                        return (OAuth2AccessToken)SerializationUtils.deserialize(rs.getBytes(2));
                    }
                }, new Object[]{tokenValue});
            }
            catch (EmptyResultDataAccessException e) {
                if (!LOG.isInfoEnabled()) break block2;
                LOG.info((Object)("Failed to find access token for token " + tokenValue));
            }
        }
        return accessToken;
    }

    @Override
    public void removeAccessToken(OAuth2AccessToken token) {
        this.removeAccessToken(token.getValue());
    }

    public void removeAccessToken(String tokenValue) {
        this.jdbcTemplate.update(this.deleteAccessTokenSql, new Object[]{tokenValue});
    }

    @Override
    public OAuth2Authentication readAuthentication(OAuth2AccessToken token) {
        return this.readAuthentication(token.getValue());
    }

    @Override
    public OAuth2Authentication readAuthentication(String token) {
        OAuth2Authentication authentication;
        block2: {
            authentication = null;
            try {
                authentication = (OAuth2Authentication)((Object)this.jdbcTemplate.queryForObject(this.selectAccessTokenAuthenticationSql, (RowMapper)new RowMapper<OAuth2Authentication>(){

                    public OAuth2Authentication mapRow(ResultSet rs, int rowNum) throws SQLException {
                        return (OAuth2Authentication)((Object)SerializationUtils.deserialize(rs.getBytes(2)));
                    }
                }, new Object[]{token}));
            }
            catch (EmptyResultDataAccessException e) {
                if (!LOG.isInfoEnabled()) break block2;
                LOG.info((Object)("Failed to find access token for token " + token));
            }
        }
        return authentication;
    }

    @Override
    public void storeRefreshToken(OAuth2RefreshToken refreshToken, OAuth2Authentication authentication) {
        this.jdbcTemplate.update(this.insertRefreshTokenSql, new Object[]{refreshToken.getValue(), new SqlLobValue(SerializationUtils.serialize(refreshToken)), new SqlLobValue(SerializationUtils.serialize((Object)authentication))}, new int[]{12, 2004, 2004});
    }

    @Override
    public OAuth2RefreshToken readRefreshToken(String token) {
        OAuth2RefreshToken refreshToken;
        block2: {
            refreshToken = null;
            try {
                refreshToken = (OAuth2RefreshToken)this.jdbcTemplate.queryForObject(this.selectRefreshTokenSql, (RowMapper)new RowMapper<OAuth2RefreshToken>(){

                    public DefaultOAuth2RefreshToken mapRow(ResultSet rs, int rowNum) throws SQLException {
                        return (DefaultOAuth2RefreshToken)SerializationUtils.deserialize(rs.getBytes(2));
                    }
                }, new Object[]{token});
            }
            catch (EmptyResultDataAccessException e) {
                if (!LOG.isInfoEnabled()) break block2;
                LOG.info((Object)("Failed to find refresh token for token " + token));
            }
        }
        return refreshToken;
    }

    @Override
    public void removeRefreshToken(OAuth2RefreshToken token) {
        this.removeRefreshToken(token.getValue());
    }

    public void removeRefreshToken(String token) {
        this.jdbcTemplate.update(this.deleteRefreshTokenSql, new Object[]{token});
    }

    @Override
    public OAuth2Authentication readAuthenticationForRefreshToken(OAuth2RefreshToken token) {
        return this.readAuthenticationForRefreshToken(token.getValue());
    }

    public OAuth2Authentication readAuthenticationForRefreshToken(String value) {
        OAuth2Authentication authentication;
        block2: {
            authentication = null;
            try {
                authentication = (OAuth2Authentication)((Object)this.jdbcTemplate.queryForObject(this.selectRefreshTokenAuthenticationSql, (RowMapper)new RowMapper<OAuth2Authentication>(){

                    public OAuth2Authentication mapRow(ResultSet rs, int rowNum) throws SQLException {
                        return (OAuth2Authentication)((Object)SerializationUtils.deserialize(rs.getBytes(2)));
                    }
                }, new Object[]{value}));
            }
            catch (EmptyResultDataAccessException e) {
                if (!LOG.isInfoEnabled()) break block2;
                LOG.info((Object)("Failed to find access token for token " + value));
            }
        }
        return authentication;
    }

    @Override
    public void removeAccessTokenUsingRefreshToken(OAuth2RefreshToken refreshToken) {
        this.removeAccessTokenUsingRefreshToken(refreshToken.getValue());
    }

    public void removeAccessTokenUsingRefreshToken(String refreshToken) {
        this.jdbcTemplate.update(this.deleteAccessTokenFromRefreshTokenSql, new Object[]{refreshToken}, new int[]{12});
    }

    @Override
    public Collection<OAuth2AccessToken> findTokensByClientId(String clientId) {
        List<OAuth2AccessToken> accessTokens;
        block2: {
            accessTokens = new ArrayList<OAuth2AccessToken>();
            try {
                accessTokens = this.jdbcTemplate.query(this.selectAccessTokensFromClientIdSql, (RowMapper)new RowMapper<OAuth2AccessToken>(){

                    public OAuth2AccessToken mapRow(ResultSet rs, int rowNum) throws SQLException {
                        return (OAuth2AccessToken)SerializationUtils.deserialize(rs.getBytes(2));
                    }
                }, new Object[]{clientId});
            }
            catch (EmptyResultDataAccessException e) {
                if (!LOG.isInfoEnabled()) break block2;
                LOG.info((Object)("Failed to find access token for clientId " + clientId));
            }
        }
        return accessTokens;
    }

    @Override
    public Collection<OAuth2AccessToken> findTokensByUserName(String userName) {
        List<OAuth2AccessToken> accessTokens;
        block2: {
            accessTokens = new ArrayList<OAuth2AccessToken>();
            try {
                accessTokens = this.jdbcTemplate.query(this.selectAccessTokensFromUserNameSql, (RowMapper)new RowMapper<OAuth2AccessToken>(){

                    public OAuth2AccessToken mapRow(ResultSet rs, int rowNum) throws SQLException {
                        return (OAuth2AccessToken)SerializationUtils.deserialize(rs.getBytes(2));
                    }
                }, new Object[]{userName});
            }
            catch (EmptyResultDataAccessException e) {
                if (!LOG.isInfoEnabled()) break block2;
                LOG.info((Object)("Failed to find access token for userName " + userName));
            }
        }
        return accessTokens;
    }

    public void setInsertAccessTokenSql(String insertAccessTokenSql) {
        this.insertAccessTokenSql = insertAccessTokenSql;
    }

    public void setSelectAccessTokenSql(String selectAccessTokenSql) {
        this.selectAccessTokenSql = selectAccessTokenSql;
    }

    public void setDeleteAccessTokenSql(String deleteAccessTokenSql) {
        this.deleteAccessTokenSql = deleteAccessTokenSql;
    }

    public void setInsertRefreshTokenSql(String insertRefreshTokenSql) {
        this.insertRefreshTokenSql = insertRefreshTokenSql;
    }

    public void setSelectRefreshTokenSql(String selectRefreshTokenSql) {
        this.selectRefreshTokenSql = selectRefreshTokenSql;
    }

    public void setDeleteRefreshTokenSql(String deleteRefreshTokenSql) {
        this.deleteRefreshTokenSql = deleteRefreshTokenSql;
    }

    public void setSelectAccessTokenAuthenticationSql(String selectAccessTokenAuthenticationSql) {
        this.selectAccessTokenAuthenticationSql = selectAccessTokenAuthenticationSql;
    }

    public void setSelectRefreshTokenAuthenticationSql(String selectRefreshTokenAuthenticationSql) {
        this.selectRefreshTokenAuthenticationSql = selectRefreshTokenAuthenticationSql;
    }

    public void setSelectAccessTokenFromAuthenticationSql(String selectAccessTokenFromAuthenticationSql) {
        this.selectAccessTokenFromAuthenticationSql = selectAccessTokenFromAuthenticationSql;
    }

    public void setDeleteAccessTokenFromRefreshTokenSql(String deleteAccessTokenFromRefreshTokenSql) {
        this.deleteAccessTokenFromRefreshTokenSql = deleteAccessTokenFromRefreshTokenSql;
    }
}

