/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.authentication;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class OAuth2AuthenticationDetails
implements Serializable {
    private static final long serialVersionUID = -4809832298438307309L;
    public static final String ACCESS_TOKEN_VALUE = OAuth2AuthenticationDetails.class.getSimpleName() + ".ACCESS_TOKEN_VALUE";
    private final String remoteAddress;
    private final String sessionId;
    private final String tokenValue;

    public OAuth2AuthenticationDetails(HttpServletRequest request) {
        this.tokenValue = (String)request.getAttribute(ACCESS_TOKEN_VALUE);
        this.remoteAddress = request.getRemoteAddr();
        HttpSession session = request.getSession(false);
        this.sessionId = session != null ? session.getId() : null;
    }

    public String getTokenValue() {
        return this.tokenValue;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public String getSessionId() {
        return this.sessionId;
    }
}

