/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.password;

import java.util.Arrays;
import java.util.Map;
import org.springframework.security.authentication.AccountStatusException;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.common.exceptions.InvalidGrantException;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.DefaultAuthorizationRequest;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.AbstractTokenGranter;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;

public class ResourceOwnerPasswordTokenGranter
extends AbstractTokenGranter {
    private static final String GRANT_TYPE = "password";
    private final AuthenticationManager authenticationManager;

    public ResourceOwnerPasswordTokenGranter(AuthenticationManager authenticationManager, AuthorizationServerTokenServices tokenServices, ClientDetailsService clientDetailsService) {
        super(tokenServices, clientDetailsService, GRANT_TYPE);
        this.authenticationManager = authenticationManager;
    }

    protected OAuth2Authentication getOAuth2Authentication(AuthorizationRequest clientToken) {
        Map<String, String> parameters = clientToken.getAuthorizationParameters();
        String username = parameters.get("username");
        String password = parameters.get(GRANT_TYPE);
        UsernamePasswordAuthenticationToken userAuth = new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
        try {
            userAuth = this.authenticationManager.authenticate((Authentication)userAuth);
        }
        catch (AccountStatusException ase) {
            throw new InvalidGrantException(ase.getMessage());
        }
        catch (BadCredentialsException e) {
            throw new InvalidGrantException(e.getMessage());
        }
        if (userAuth == null || !userAuth.isAuthenticated()) {
            throw new InvalidGrantException("Could not authenticate user: " + username);
        }
        DefaultAuthorizationRequest request = new DefaultAuthorizationRequest(clientToken);
        request.remove(Arrays.asList(GRANT_TYPE));
        return new OAuth2Authentication(request, (Authentication)userAuth);
    }
}

