/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client;

import org.springframework.http.client.ClientHttpRequest;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2RequestAuthenticator;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.util.StringUtils;

public class DefaultOAuth2RequestAuthenticator
implements OAuth2RequestAuthenticator {
    @Override
    public void authenticate(OAuth2ProtectedResourceDetails resource, OAuth2ClientContext clientContext, ClientHttpRequest request) {
        OAuth2AccessToken accessToken = clientContext.getAccessToken();
        String tokenType = accessToken.getTokenType();
        if (!StringUtils.hasText((String)tokenType)) {
            tokenType = "Bearer";
        }
        request.getHeaders().set("Authorization", String.format("%s %s", tokenType, accessToken.getValue()));
    }
}

