/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.config.annotation.web.configuration;

import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.authentication.configurers.GlobalAuthenticationConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.oauth2.config.annotation.configuration.ClientDetailsServiceConfiguration;
import org.springframework.security.oauth2.config.annotation.configurers.ClientDetailsServiceConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configurers.OAuth2AuthorizationServerConfigurer;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.OAuth2RequestFactory;
import org.springframework.security.oauth2.provider.TokenGranter;
import org.springframework.security.oauth2.provider.approval.UserApprovalHandler;
import org.springframework.security.oauth2.provider.code.AuthorizationCodeServices;
import org.springframework.security.oauth2.provider.endpoint.AuthorizationEndpoint;
import org.springframework.security.oauth2.provider.endpoint.FrameworkEndpointHandlerMapping;
import org.springframework.security.oauth2.provider.endpoint.TokenEndpoint;
import org.springframework.security.oauth2.provider.endpoint.WhitelabelApprovalEndpoint;
import org.springframework.security.oauth2.provider.implicit.ImplicitGrantService;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;
import org.springframework.security.oauth2.provider.token.ConsumerTokenServices;
import org.springframework.security.oauth2.provider.token.TokenStore;

@Configuration
@Import(value={ClientDetailsServiceConfiguration.class})
@Order(value=0)
public class AuthorizationServerConfiguration
extends WebSecurityConfigurerAdapter {
    @Autowired
    private List<AuthorizationServerConfigurer> configurers = Collections.emptyList();
    @Autowired
    private ClientDetailsService clientDetailsService;
    @Autowired
    private AuthorizationEndpoint authorizationEndpoint;

    @Autowired
    public void configure(ClientDetailsServiceConfigurer clientDetails) throws Exception {
        for (AuthorizationServerConfigurer configurer : this.configurers) {
            configurer.configure(clientDetails);
        }
    }

    protected void configure(HttpSecurity http) throws Exception {
        OAuth2AuthorizationServerConfigurer configurer = new OAuth2AuthorizationServerConfigurer();
        configurer.clientDetailsService(this.clientDetailsService);
        this.configure(configurer);
        http.apply((SecurityConfigurerAdapter)configurer);
        String tokenEndpointPath = this.oauth2EndpointHandlerMapping().getPath("/oauth/token");
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{tokenEndpointPath})).fullyAuthenticated().and()).requestMatchers().antMatchers(new String[]{tokenEndpointPath});
        http.setSharedObject(ClientDetailsService.class, (Object)this.clientDetailsService);
    }

    protected void configure(OAuth2AuthorizationServerConfigurer oauthServer) throws Exception {
        for (AuthorizationServerConfigurer configurer : this.configurers) {
            configurer.configure(oauthServer);
        }
    }

    @Bean
    public AuthorizationEndpoint authorizationEndpoint() throws Exception {
        AuthorizationEndpoint authorizationEndpoint = new AuthorizationEndpoint();
        authorizationEndpoint.setTokenGranter(this.tokenGranter());
        authorizationEndpoint.setClientDetailsService(this.clientDetailsService);
        authorizationEndpoint.setAuthorizationCodeServices(this.authorizationCodeServices());
        authorizationEndpoint.setUserApprovalHandler(this.userApprovalHandler());
        authorizationEndpoint.setImplicitGrantService(this.implicitGrantService());
        return authorizationEndpoint;
    }

    @Bean
    @Lazy
    @Scope(proxyMode=ScopedProxyMode.INTERFACES)
    public ImplicitGrantService implicitGrantService() throws Exception {
        return this.authorizationServerConfigurer().getImplicitGrantService();
    }

    @Bean
    @Lazy
    @Scope(proxyMode=ScopedProxyMode.INTERFACES)
    public ConsumerTokenServices consumerTokenServices() throws Exception {
        return this.authorizationServerConfigurer().getConsumerTokenServices();
    }

    @Bean
    public TokenEndpoint tokenEndpoint() throws Exception {
        TokenEndpoint tokenEndpoint = new TokenEndpoint();
        tokenEndpoint.setClientDetailsService(this.clientDetailsService);
        tokenEndpoint.setTokenGranter(this.tokenGranter());
        return tokenEndpoint;
    }

    @Bean
    @Lazy
    @Scope(proxyMode=ScopedProxyMode.INTERFACES)
    public OAuth2RequestFactory oauth2RequestFactory() throws Exception {
        return this.authorizationServerConfigurer().getOAuth2RequestFactory();
    }

    @Bean
    @Lazy
    @Scope(proxyMode=ScopedProxyMode.INTERFACES)
    public TokenStore tokenStore() throws Exception {
        return this.authorizationServerConfigurer().getTokenStore();
    }

    @Bean
    @Lazy
    @Scope(proxyMode=ScopedProxyMode.INTERFACES)
    public UserApprovalHandler userApprovalHandler() throws Exception {
        return this.authorizationServerConfigurer().getUserApprovalHandler();
    }

    protected AuthorizationServerTokenServices tokenServices() throws Exception {
        return this.authorizationServerConfigurer().getTokenServices();
    }

    @Bean
    public WhitelabelApprovalEndpoint approvalEndpoint() {
        return new WhitelabelApprovalEndpoint();
    }

    @Bean
    @Lazy
    @Scope(proxyMode=ScopedProxyMode.TARGET_CLASS)
    public FrameworkEndpointHandlerMapping oauth2EndpointHandlerMapping() throws Exception {
        FrameworkEndpointHandlerMapping mapping = this.authorizationServerConfigurer().getFrameworkEndpointHandlerMapping();
        this.authorizationEndpoint.setUserApprovalPage(this.extractPath(mapping, "/oauth/confirm_access"));
        this.authorizationEndpoint.setErrorPage(this.extractPath(mapping, "/oauth/error"));
        return mapping;
    }

    private String extractPath(FrameworkEndpointHandlerMapping mapping, String page) {
        String path = mapping.getPath(page);
        if (path.contains(":")) {
            return path;
        }
        return "forward:" + path;
    }

    @Bean
    @Lazy
    @Scope(proxyMode=ScopedProxyMode.INTERFACES)
    public AuthorizationCodeServices authorizationCodeServices() throws Exception {
        return this.authorizationServerConfigurer().getAuthorizationCodeServices();
    }

    @Bean
    @Lazy
    @Scope(proxyMode=ScopedProxyMode.INTERFACES)
    public TokenGranter tokenGranter() throws Exception {
        return this.authorizationServerConfigurer().getTokenGranter();
    }

    private OAuth2AuthorizationServerConfigurer authorizationServerConfigurer() throws Exception {
        return (OAuth2AuthorizationServerConfigurer)this.getHttp().getConfigurer(OAuth2AuthorizationServerConfigurer.class);
    }

    @Configuration
    protected static class ClientDetailsAuthenticationManagerConfiguration
    extends GlobalAuthenticationConfigurerAdapter {
        protected ClientDetailsAuthenticationManagerConfiguration() {
        }
    }
}

