/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.config.annotation.web.configuration;

import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configurers.OAuth2ResourceServerConfigurer;
import org.springframework.security.oauth2.provider.endpoint.FrameworkEndpointHandlerMapping;
import org.springframework.security.oauth2.provider.error.OAuth2AccessDeniedHandler;
import org.springframework.security.oauth2.provider.expression.OAuth2WebSecurityExpressionHandler;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@Order(value=3)
public class ResourceServerConfiguration
extends WebSecurityConfigurerAdapter {
    @Autowired
    private TokenStore tokenStore;
    @Autowired(required=false)
    private FrameworkEndpointHandlerMapping frameworkEndpointHandlerMapping;
    private List<ResourceServerConfigurer> configurers = Collections.emptyList();
    private AccessDeniedHandler accessDeniedHandler = new OAuth2AccessDeniedHandler();

    @Autowired(required=false)
    public void setConfigurers(List<ResourceServerConfigurer> configurers) {
        this.configurers = configurers;
    }

    protected void configure(HttpSecurity http) throws Exception {
        HttpSecurity.RequestMatcherConfigurer requests = http.requestMatchers();
        if (this.frameworkEndpointHandlerMapping != null) {
            requests.requestMatchers(new RequestMatcher[]{new NotOAuthRequstMatcher(this.frameworkEndpointHandlerMapping)});
        }
        ((HttpSecurity)http.exceptionHandling().accessDeniedHandler(this.accessDeniedHandler).and()).csrf().disable();
        for (ResourceServerConfigurer configurer : this.configurers) {
            configurer.configure(http);
        }
        if (this.configurers.isEmpty()) {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().anyRequest()).authenticated();
        }
        http.authorizeRequests().expressionHandler((SecurityExpressionHandler)new OAuth2WebSecurityExpressionHandler());
        OAuth2ResourceServerConfigurer resources = new OAuth2ResourceServerConfigurer();
        http.apply((SecurityConfigurerAdapter)resources);
        for (ResourceServerConfigurer configurer : this.configurers) {
            configurer.configure(resources);
        }
        resources.tokenStore(this.tokenStore);
    }

    private static class NotOAuthRequstMatcher
    implements RequestMatcher {
        private FrameworkEndpointHandlerMapping mapping;

        public NotOAuthRequstMatcher(FrameworkEndpointHandlerMapping mapping) {
            this.mapping = mapping;
        }

        public boolean matches(HttpServletRequest request) {
            String requestPath = this.getRequestPath(request);
            for (String path : this.mapping.getPaths()) {
                if (!requestPath.startsWith(path)) continue;
                return false;
            }
            return true;
        }

        private String getRequestPath(HttpServletRequest request) {
            String url = request.getServletPath();
            if (request.getPathInfo() != null) {
                url = url + request.getPathInfo();
            }
            return url;
        }
    }
}

