/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.config.annotation.web.configurers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import org.springframework.http.MediaType;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExceptionHandlingConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.CompositeTokenGranter;
import org.springframework.security.oauth2.provider.DefaultOAuth2RequestFactory;
import org.springframework.security.oauth2.provider.InMemoryClientDetailsService;
import org.springframework.security.oauth2.provider.OAuth2RequestFactory;
import org.springframework.security.oauth2.provider.TokenGranter;
import org.springframework.security.oauth2.provider.approval.TokenStoreUserApprovalHandler;
import org.springframework.security.oauth2.provider.approval.UserApprovalHandler;
import org.springframework.security.oauth2.provider.client.ClientCredentialsTokenEndpointFilter;
import org.springframework.security.oauth2.provider.client.ClientCredentialsTokenGranter;
import org.springframework.security.oauth2.provider.client.ClientDetailsUserDetailsService;
import org.springframework.security.oauth2.provider.code.AuthorizationCodeServices;
import org.springframework.security.oauth2.provider.code.AuthorizationCodeTokenGranter;
import org.springframework.security.oauth2.provider.code.InMemoryAuthorizationCodeServices;
import org.springframework.security.oauth2.provider.endpoint.FrameworkEndpointHandlerMapping;
import org.springframework.security.oauth2.provider.error.OAuth2AccessDeniedHandler;
import org.springframework.security.oauth2.provider.error.OAuth2AuthenticationEntryPoint;
import org.springframework.security.oauth2.provider.implicit.ImplicitGrantService;
import org.springframework.security.oauth2.provider.implicit.ImplicitTokenGranter;
import org.springframework.security.oauth2.provider.implicit.InMemoryImplicitGrantService;
import org.springframework.security.oauth2.provider.password.ResourceOwnerPasswordTokenGranter;
import org.springframework.security.oauth2.provider.refresh.RefreshTokenGranter;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;
import org.springframework.security.oauth2.provider.token.ConsumerTokenServices;
import org.springframework.security.oauth2.provider.token.DefaultTokenServices;
import org.springframework.security.oauth2.provider.token.InMemoryTokenStore;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.context.NullSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.security.web.util.matcher.MediaTypeRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.accept.ContentNegotiationStrategy;
import org.springframework.web.accept.HeaderContentNegotiationStrategy;

public final class OAuth2AuthorizationServerConfigurer
extends SecurityConfigurerAdapter<DefaultSecurityFilterChain, HttpSecurity> {
    private AuthenticationEntryPoint authenticationEntryPoint = new OAuth2AuthenticationEntryPoint();
    private AccessDeniedHandler accessDeniedHandler = new OAuth2AccessDeniedHandler();
    private AuthorizationServerTokenServices tokenServices;
    private ConsumerTokenServices consumerTokenServices;
    private AuthorizationCodeServices authorizationCodeServices;
    private ImplicitGrantService implicitGrantService = new InMemoryImplicitGrantService();
    private TokenStore tokenStore;
    private TokenGranter tokenGranter;
    private OAuth2RequestFactory requestFactory;
    private UserApprovalHandler userApprovalHandler;
    private AuthenticationManager authenticationManager;
    private ClientDetailsService clientDetailsService;
    private String realm = "oauth2/client";
    private Map<String, String> patternMap = new HashMap<String, String>();
    private FrameworkEndpointHandlerMapping frameworkEndpointHandlerMapping;
    private boolean allowFormAuthenticationForClients = false;

    private ClientDetailsService clientDetails() {
        return (ClientDetailsService)((HttpSecurity)this.getBuilder()).getSharedObject(ClientDetailsService.class);
    }

    public AuthorizationServerTokenServices getTokenServices() {
        return this.tokenServices;
    }

    public TokenStore getTokenStore() {
        return this.tokenStore;
    }

    public ClientDetailsService getClientDetailsService() {
        return this.clientDetailsService;
    }

    public OAuth2RequestFactory getOAuth2RequestFactory() {
        return this.requestFactory;
    }

    public UserApprovalHandler getUserApprovalHandler() {
        return this.userApprovalHandler;
    }

    public OAuth2AuthorizationServerConfigurer allowFormAuthenticationForClients() {
        this.allowFormAuthenticationForClients = true;
        return this;
    }

    public OAuth2AuthorizationServerConfigurer tokenStore(TokenStore tokenStore) {
        this.tokenStore = tokenStore;
        return this;
    }

    public OAuth2AuthorizationServerConfigurer tokenService(AuthorizationServerTokenServices tokenServices) {
        this.tokenServices = tokenServices;
        return this;
    }

    public OAuth2AuthorizationServerConfigurer userApprovalHandler(UserApprovalHandler approvalHandler) {
        this.userApprovalHandler = approvalHandler;
        return this;
    }

    public OAuth2AuthorizationServerConfigurer realm(String realm) {
        this.realm = realm;
        return this;
    }

    public OAuth2AuthorizationServerConfigurer pathMapping(String defaultPath, String customPath) {
        this.patternMap.put(defaultPath, customPath);
        return this;
    }

    public OAuth2AuthorizationServerConfigurer authenticationEntryPoint(AuthenticationEntryPoint authenticationEntryPoint) {
        this.authenticationEntryPoint = authenticationEntryPoint;
        return this;
    }

    public OAuth2AuthorizationServerConfigurer authenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
        return this;
    }

    public OAuth2AuthorizationServerConfigurer clientDetailsService(ClientDetailsService clientDetailsService) {
        this.clientDetailsService = clientDetailsService;
        return this;
    }

    public void init(HttpSecurity http) throws Exception {
        this.registerDefaultAuthenticationEntryPoint(http);
        ((HttpSecurity)((HttpSecurity)http.userDetailsService((UserDetailsService)new ClientDetailsUserDetailsService(this.clientDetailsService())).securityContext().securityContextRepository((SecurityContextRepository)new NullSecurityContextRepository()).and()).csrf().disable()).httpBasic().realmName(this.realm);
    }

    private void registerDefaultAuthenticationEntryPoint(HttpSecurity http) {
        ExceptionHandlingConfigurer exceptionHandling = (ExceptionHandlingConfigurer)http.getConfigurer(ExceptionHandlingConfigurer.class);
        if (exceptionHandling == null) {
            return;
        }
        ContentNegotiationStrategy contentNegotiationStrategy = (ContentNegotiationStrategy)http.getSharedObject(ContentNegotiationStrategy.class);
        if (contentNegotiationStrategy == null) {
            contentNegotiationStrategy = new HeaderContentNegotiationStrategy();
        }
        MediaTypeRequestMatcher preferredMatcher = new MediaTypeRequestMatcher(contentNegotiationStrategy, new MediaType[]{MediaType.APPLICATION_ATOM_XML, MediaType.APPLICATION_FORM_URLENCODED, MediaType.APPLICATION_JSON, MediaType.APPLICATION_OCTET_STREAM, MediaType.APPLICATION_XML, MediaType.MULTIPART_FORM_DATA, MediaType.TEXT_XML});
        preferredMatcher.setIgnoredMediaTypes(Collections.singleton(MediaType.ALL));
        exceptionHandling.defaultAuthenticationEntryPointFor((AuthenticationEntryPoint)this.postProcess(this.authenticationEntryPoint), (RequestMatcher)preferredMatcher);
    }

    public void configure(HttpSecurity http) throws Exception {
        this.tokenGranter = this.tokenGranter(http);
        this.consumerTokenServices = this.consumerTokenServices(http);
        this.userApprovalHandler = this.userApprovalHandler();
        this.frameworkEndpointHandlerMapping();
        if (this.allowFormAuthenticationForClients) {
            this.clientCredentialsTokenEndpointFilter(http);
        }
        http.exceptionHandling().accessDeniedHandler(this.accessDeniedHandler);
    }

    private ClientCredentialsTokenEndpointFilter clientCredentialsTokenEndpointFilter(HttpSecurity http) {
        ClientCredentialsTokenEndpointFilter clientCredentialsTokenEndpointFilter = new ClientCredentialsTokenEndpointFilter(this.frameworkEndpointHandlerMapping().getPath("/oauth/token"));
        clientCredentialsTokenEndpointFilter.setAuthenticationManager((AuthenticationManager)http.getSharedObject(AuthenticationManager.class));
        clientCredentialsTokenEndpointFilter = (ClientCredentialsTokenEndpointFilter)((Object)this.postProcess((Object)clientCredentialsTokenEndpointFilter));
        http.addFilterBefore((Filter)clientCredentialsTokenEndpointFilter, BasicAuthenticationFilter.class);
        return clientCredentialsTokenEndpointFilter;
    }

    public ConsumerTokenServices getConsumerTokenServices() {
        return this.consumerTokenServices;
    }

    public ImplicitGrantService getImplicitGrantService() {
        return this.implicitGrantService;
    }

    private ConsumerTokenServices consumerTokenServices(HttpSecurity http) {
        if (this.consumerTokenServices == null) {
            DefaultTokenServices defaultTokenServices = new DefaultTokenServices();
            defaultTokenServices.setClientDetailsService(this.clientDetails());
            defaultTokenServices.setTokenStore(this.tokenStore());
            this.consumerTokenServices = defaultTokenServices;
        }
        return this.consumerTokenServices;
    }

    private AuthorizationServerTokenServices tokenServices(HttpSecurity http) {
        if (this.tokenServices != null) {
            return this.tokenServices;
        }
        DefaultTokenServices tokenServices = new DefaultTokenServices();
        tokenServices.setTokenStore(this.tokenStore());
        tokenServices.setSupportRefreshToken(true);
        tokenServices.setClientDetailsService(this.clientDetails());
        this.tokenServices = tokenServices;
        return tokenServices;
    }

    private TokenStore tokenStore() {
        if (this.tokenStore == null) {
            this.tokenStore = new InMemoryTokenStore();
        }
        return this.tokenStore;
    }

    private ClientDetailsService clientDetailsService() {
        if (this.clientDetailsService == null) {
            this.clientDetailsService = new InMemoryClientDetailsService();
        }
        return this.clientDetailsService;
    }

    private UserApprovalHandler userApprovalHandler() {
        if (this.userApprovalHandler == null) {
            TokenStoreUserApprovalHandler userApprovalHandler = new TokenStoreUserApprovalHandler();
            userApprovalHandler.setTokenStore(this.tokenStore());
            userApprovalHandler.setClientDetailsService(this.clientDetails());
            userApprovalHandler.setRequestFactory(new DefaultOAuth2RequestFactory(this.clientDetailsService()));
            this.userApprovalHandler = userApprovalHandler;
        }
        return this.userApprovalHandler;
    }

    public AuthorizationCodeServices getAuthorizationCodeServices() {
        return this.authorizationCodeServices;
    }

    private AuthorizationCodeServices authorizationCodeServices(HttpSecurity http) {
        if (this.authorizationCodeServices == null) {
            this.authorizationCodeServices = new InMemoryAuthorizationCodeServices();
        }
        return this.authorizationCodeServices;
    }

    private OAuth2RequestFactory requestFactory(HttpSecurity http) {
        if (this.requestFactory != null) {
            return this.requestFactory;
        }
        this.requestFactory = new DefaultOAuth2RequestFactory(this.clientDetails());
        return this.requestFactory;
    }

    public TokenGranter getTokenGranter() {
        return this.tokenGranter;
    }

    private TokenGranter tokenGranter(HttpSecurity http) throws Exception {
        if (this.tokenGranter == null) {
            ClientDetailsService clientDetails = this.clientDetails();
            AuthorizationServerTokenServices tokenServices = this.tokenServices(http);
            AuthorizationCodeServices authorizationCodeServices = this.authorizationCodeServices(http);
            OAuth2RequestFactory requestFactory = this.requestFactory(http);
            ArrayList<TokenGranter> tokenGranters = new ArrayList<TokenGranter>();
            tokenGranters.add(new AuthorizationCodeTokenGranter(tokenServices, authorizationCodeServices, clientDetails, requestFactory));
            tokenGranters.add(new RefreshTokenGranter(tokenServices, clientDetails, requestFactory));
            ImplicitTokenGranter implicit = new ImplicitTokenGranter(tokenServices, clientDetails, requestFactory);
            implicit.setImplicitGrantService(this.implicitGrantService);
            tokenGranters.add(implicit);
            tokenGranters.add(new ClientCredentialsTokenGranter(tokenServices, clientDetails, requestFactory));
            if (this.authenticationManager != null) {
                tokenGranters.add(new ResourceOwnerPasswordTokenGranter(this.authenticationManager, tokenServices, clientDetails, requestFactory));
            }
            this.tokenGranter = new CompositeTokenGranter(tokenGranters);
        }
        return this.tokenGranter;
    }

    public FrameworkEndpointHandlerMapping getFrameworkEndpointHandlerMapping() {
        return this.frameworkEndpointHandlerMapping();
    }

    private FrameworkEndpointHandlerMapping frameworkEndpointHandlerMapping() {
        if (this.frameworkEndpointHandlerMapping == null) {
            this.frameworkEndpointHandlerMapping = new FrameworkEndpointHandlerMapping();
            this.frameworkEndpointHandlerMapping.setMappings(this.patternMap);
        }
        return this.frameworkEndpointHandlerMapping;
    }
}

