/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.token;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.common.DefaultExpiringOAuth2RefreshToken;
import org.springframework.security.oauth2.common.DefaultOAuth2AccessToken;
import org.springframework.security.oauth2.common.ExpiringOAuth2RefreshToken;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.InvalidGrantException;
import org.springframework.security.oauth2.common.exceptions.InvalidScopeException;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.TokenRequest;
import org.springframework.security.oauth2.provider.token.AccessTokenConverter;
import org.springframework.security.oauth2.provider.token.AuthenticationKeyGenerator;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;
import org.springframework.security.oauth2.provider.token.DefaultAccessTokenConverter;
import org.springframework.security.oauth2.provider.token.DefaultAuthenticationKeyGenerator;
import org.springframework.security.oauth2.provider.token.JwtTokenEnhancer;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.security.oauth2.provider.token.TokenEnhancer;

public class JwtTokenServices
implements AuthorizationServerTokenServices,
ResourceServerTokenServices,
InitializingBean {
    public static final String TOKEN_ID = "jti";
    private AccessTokenConverter tokenConverter = new DefaultAccessTokenConverter();
    private ClientDetailsService clientDetailsService;
    private TokenEnhancer accessTokenEnhancer;
    private JwtTokenEnhancer jwtTokenEnhancer = new JwtTokenEnhancer();
    private int refreshTokenValiditySeconds = 2592000;
    private int accessTokenValiditySeconds = 43200;
    private boolean supportRefreshToken = true;
    private boolean reuseRefreshToken = true;
    private AuthenticationKeyGenerator authenticationKeyGenerator = new DefaultAuthenticationKeyGenerator();

    public void setSupportRefreshToken(boolean supportRefreshToken) {
        this.supportRefreshToken = supportRefreshToken;
    }

    public void setReuseRefreshToken(boolean reuseRefreshToken) {
        this.reuseRefreshToken = reuseRefreshToken;
    }

    public void setTokenEnhancer(TokenEnhancer accessTokenEnhancer) {
        this.accessTokenEnhancer = accessTokenEnhancer;
    }

    public void setRefreshTokenValiditySeconds(int refreshTokenValiditySeconds) {
        this.refreshTokenValiditySeconds = refreshTokenValiditySeconds;
    }

    public void setAccessTokenValiditySeconds(int accessTokenValiditySeconds) {
        this.accessTokenValiditySeconds = accessTokenValiditySeconds;
    }

    public void setClientDetailsService(ClientDetailsService clientDetailsService) {
        this.clientDetailsService = clientDetailsService;
    }

    public void setAuthenticationKeyGenerator(AuthenticationKeyGenerator authenticationKeyGenerator) {
        this.authenticationKeyGenerator = authenticationKeyGenerator;
    }

    public void setVerifierKey(String key) {
        this.jwtTokenEnhancer.setVerifierKey(key);
    }

    public void setSigningKey(String key) {
        this.jwtTokenEnhancer.setSigningKey(key);
    }

    public void afterPropertiesSet() throws Exception {
        this.jwtTokenEnhancer.afterPropertiesSet();
    }

    @Override
    public OAuth2Authentication loadAuthentication(String token) throws AuthenticationException {
        return this.tokenConverter.extractAuthentication(this.decode(token));
    }

    @Override
    public OAuth2AccessToken readAccessToken(String token) {
        return this.tokenConverter.extractAccessToken(token, this.decode(token));
    }

    @Override
    public OAuth2AccessToken createAccessToken(OAuth2Authentication authentication) throws AuthenticationException {
        DefaultOAuth2AccessToken result = new DefaultOAuth2AccessToken(this.getAccessToken(authentication));
        result.setRefreshToken(this.createRefreshToken(authentication));
        return result;
    }

    @Override
    public OAuth2AccessToken refreshAccessToken(String refreshTokenValue, TokenRequest request) throws AuthenticationException {
        if (!this.supportRefreshToken) {
            throw new InvalidGrantException("Invalid refresh token: " + refreshTokenValue);
        }
        OAuth2Authentication authentication = this.loadAuthentication(refreshTokenValue);
        String clientId = authentication.getOAuth2Request().getClientId();
        if (clientId == null || !clientId.equals(request.getClientId())) {
            throw new InvalidGrantException("Wrong client for this refresh token: " + refreshTokenValue);
        }
        OAuth2AccessToken refreshTokenData = this.readAccessToken(refreshTokenValue);
        if (this.isExpired(refreshTokenData)) {
            throw new InvalidTokenException("Invalid refresh token (expired): " + refreshTokenValue);
        }
        authentication = this.createRefreshedAuthentication(authentication, request.getScope());
        OAuth2AccessToken accessToken = this.createAccessToken(authentication);
        if (!this.reuseRefreshToken) {
            ExpiringOAuth2RefreshToken refreshToken = this.createRefreshToken(authentication);
            DefaultOAuth2AccessToken result = new DefaultOAuth2AccessToken(accessToken);
            result.setRefreshToken(refreshToken);
        }
        return accessToken;
    }

    @Override
    public OAuth2AccessToken getAccessToken(OAuth2Authentication authentication) {
        String tokenId = this.authenticationKeyGenerator.extractKey(authentication);
        DefaultOAuth2AccessToken result = new DefaultOAuth2AccessToken(tokenId);
        LinkedHashMap<String, Object> info = new LinkedHashMap<String, Object>();
        info.put(TOKEN_ID, tokenId);
        result.setAdditionalInformation(info);
        int validitySeconds = this.getAccessTokenValiditySeconds(authentication.getOAuth2Request());
        if (validitySeconds > 0) {
            result.setExpiration(new Date(System.currentTimeMillis() + (long)validitySeconds * 1000L));
        }
        result.setScope(authentication.getOAuth2Request().getScope());
        if (this.accessTokenEnhancer != null) {
            result = new DefaultOAuth2AccessToken(this.accessTokenEnhancer.enhance(result, authentication));
        }
        DefaultOAuth2AccessToken token = result.setValue(this.encode(result, authentication));
        return token;
    }

    protected boolean isExpired(OAuth2AccessToken expiringToken) {
        return expiringToken.getExpiration() != null && System.currentTimeMillis() > expiringToken.getExpiration().getTime();
    }

    protected boolean isSupportRefreshToken(OAuth2Request authorizationRequest) {
        if (this.clientDetailsService != null) {
            ClientDetails client = this.clientDetailsService.loadClientByClientId(authorizationRequest.getClientId());
            return client.getAuthorizedGrantTypes().contains("refresh_token");
        }
        return this.supportRefreshToken;
    }

    protected int getAccessTokenValiditySeconds(OAuth2Request authorizationRequest) {
        ClientDetails client;
        Integer validity;
        if (this.clientDetailsService != null && (validity = (client = this.clientDetailsService.loadClientByClientId(authorizationRequest.getClientId())).getAccessTokenValiditySeconds()) != null) {
            return validity;
        }
        return this.accessTokenValiditySeconds;
    }

    protected int getRefreshTokenValiditySeconds(OAuth2Request authorizationRequest) {
        ClientDetails client;
        Integer validity;
        if (this.clientDetailsService != null && (validity = (client = this.clientDetailsService.loadClientByClientId(authorizationRequest.getClientId())).getRefreshTokenValiditySeconds()) != null) {
            return validity;
        }
        return this.refreshTokenValiditySeconds;
    }

    private String encode(OAuth2AccessToken accessToken, OAuth2Authentication authentication) {
        return this.jwtTokenEnhancer.encode(accessToken, authentication);
    }

    private Map<String, Object> decode(String token) {
        return this.jwtTokenEnhancer.decode(token);
    }

    private OAuth2Authentication createRefreshedAuthentication(OAuth2Authentication authentication, Set<String> scope) {
        OAuth2Authentication narrowed = authentication;
        if (scope != null && !scope.isEmpty()) {
            OAuth2Request clientAuth = authentication.getOAuth2Request();
            Set originalScope = clientAuth.getScope();
            if (originalScope == null || !originalScope.containsAll(scope)) {
                throw new InvalidScopeException("Unable to narrow the scope of the client authentication to " + scope + ".", originalScope);
            }
            narrowed = new OAuth2Authentication(clientAuth.narrowScope(scope), authentication.getUserAuthentication());
        }
        return narrowed;
    }

    private ExpiringOAuth2RefreshToken createRefreshToken(OAuth2Authentication authentication) {
        if (!this.isSupportRefreshToken(authentication.getOAuth2Request())) {
            return null;
        }
        DefaultOAuth2AccessToken accessToken = new DefaultOAuth2AccessToken(this.getAccessToken(authentication));
        int validitySeconds = this.getRefreshTokenValiditySeconds(authentication.getOAuth2Request());
        Date expiration = new Date(System.currentTimeMillis() + (long)validitySeconds * 1000L);
        accessToken.setExpiration(expiration);
        accessToken.setValue(this.encode(accessToken, authentication));
        DefaultExpiringOAuth2RefreshToken refreshToken = new DefaultExpiringOAuth2RefreshToken(accessToken.getValue(), expiration);
        return refreshToken;
    }
}

