/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.test;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.springframework.security.oauth2.client.resource.BaseOAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.test.TestAccounts;
import org.springframework.security.oauth2.client.token.grant.client.ClientCredentialsResourceDetails;
import org.springframework.security.oauth2.client.token.grant.implicit.ImplicitResourceDetails;
import org.springframework.security.oauth2.client.token.grant.password.ResourceOwnerPasswordResourceDetails;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.METHOD})
public @interface OAuth2ContextConfiguration {
    public Class<? extends OAuth2ProtectedResourceDetails> value() default OAuth2ProtectedResourceDetails.class;

    public Class<? extends OAuth2ProtectedResourceDetails> resource() default Password.class;

    public boolean initialize() default true;

    public static class Implicit
    extends ImplicitResourceDetails {
        public Implicit(TestAccounts testAccounts) {
            ImplicitResourceDetails resource = testAccounts.getDefaultImplicitResource();
            ResourceHelper.initialize(resource, this);
            this.setPreEstablishedRedirectUri(resource.getPreEstablishedRedirectUri());
        }
    }

    public static class Password
    extends ResourceOwnerPasswordResourceDetails {
        public Password(TestAccounts testAccounts) {
            ResourceOwnerPasswordResourceDetails resource = testAccounts.getDefaultResourceOwnerPasswordResource();
            ResourceHelper.initialize(resource, this);
            this.setUsername(resource.getUsername());
            this.setPassword(resource.getPassword());
        }
    }

    public static class ClientCredentials
    extends ClientCredentialsResourceDetails {
        public ClientCredentials(TestAccounts testAccounts) {
            ClientCredentialsResourceDetails resource = testAccounts.getDefaultClientCredentialsResource();
            ResourceHelper.initialize(resource, this);
        }
    }

    public static class ResourceHelper {
        public static void initialize(OAuth2ProtectedResourceDetails source, BaseOAuth2ProtectedResourceDetails target) {
            target.setClientId(source.getClientId());
            target.setClientSecret(source.getClientSecret());
            target.setScope(source.getScope());
            target.setId(source.getId());
            target.setAccessTokenUri(source.getAccessTokenUri());
        }
    }
}

